/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.threadlocal;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.SubstrateDiagnostics;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.heap.UnknownObjectField;
import com.oracle.svm.core.layeredimagesingleton.InitialLayerOnlyImageSingleton;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonBuilderFlags;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.threadlocal.FastThreadLocal;
import com.oracle.svm.core.threadlocal.FastThreadLocalBytes;
import com.oracle.svm.core.threadlocal.FastThreadLocalInt;
import com.oracle.svm.core.threadlocal.FastThreadLocalLong;
import com.oracle.svm.core.threadlocal.FastThreadLocalObject;
import com.oracle.svm.core.threadlocal.FastThreadLocalWord;
import com.oracle.svm.core.threadlocal.VMThreadLocalInfo;
import java.util.Collection;
import java.util.EnumSet;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

@AutomaticallyRegisteredImageSingleton
public class VMThreadLocalInfos
implements InitialLayerOnlyImageSingleton {
    @UnknownObjectField(availability=BuildPhaseProvider.ReadyForCompilation.class)
    private VMThreadLocalInfo[] infos;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void setInfos(Collection<VMThreadLocalInfo> infos) {
        VMThreadLocalInfos singleton = (VMThreadLocalInfos)ImageSingletons.lookup(VMThreadLocalInfos.class);
        singleton.infos = infos.toArray(new VMThreadLocalInfo[0]);
    }

    public static void dumpToLog(Log log, IsolateThread thread, boolean isJavaHeapAccessAllowed) {
        Pointer threadLocals = (Pointer)thread;
        for (VMThreadLocalInfo info : ((VMThreadLocalInfos)ImageSingletons.lookup(VMThreadLocalInfos.class)).infos) {
            log.signed(info.offset).string(": ").string(info.name).string(" = ");
            if (info.threadLocalClass == FastThreadLocalInt.class) {
                int value = threadLocals.readInt((WordBase)WordFactory.signed((int)info.offset));
                log.string("(int) ").zhex(value).string(" (").signed(value).string(")");
            } else if (info.threadLocalClass == FastThreadLocalLong.class) {
                long value = threadLocals.readLong((WordBase)WordFactory.signed((int)info.offset));
                log.string("(long) ").zhex(value).string(" (").signed(value).string(")");
            } else if (info.threadLocalClass == FastThreadLocalWord.class) {
                WordBase value = threadLocals.readWord((WordBase)WordFactory.signed((int)info.offset));
                log.string("(Word) ").zhex(value).string(" (").signed(value).string(")");
            } else if (info.threadLocalClass == FastThreadLocalObject.class) {
                if (isJavaHeapAccessAllowed) {
                    Object value = VMThreadLocalInfos.readThreadLocalObject(threadLocals, info.offset);
                    log.string("(Object) ").zhex((WordBase)Word.objectToUntrackedPointer((Object)value));
                    if (value != null) {
                        log.indent(true);
                        SubstrateDiagnostics.printObjectInfo(log, value);
                        log.redent(false);
                    }
                } else {
                    Word value = VMThreadLocalInfos.readThreadLocalObjectAsWord(threadLocals, info.offset);
                    log.string("(Object) ").zhex((WordBase)value);
                }
            } else if (info.threadLocalClass == FastThreadLocalBytes.class) {
                log.string("(bytes) ");
                Pointer data = threadLocals.add((UnsignedWord)WordFactory.signed((int)info.offset));
                if (info.sizeInBytes == 8) {
                    log.zhex(data.readWord(0));
                } else {
                    log.indent(true);
                    if (info.sizeInBytes % 8 == 0) {
                        log.hexdump((PointerBase)data, 8, info.sizeInBytes / 8);
                    } else {
                        log.hexdump((PointerBase)data, 1, info.sizeInBytes);
                    }
                    log.redent(false);
                }
            } else {
                log.string("unknown class ").string(info.threadLocalClass.getName());
            }
            log.newline();
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static Word readThreadLocalObjectAsWord(Pointer threadLocals, int offset) {
        return ReferenceAccess.singleton().readObjectAsUntrackedPointer(threadLocals.add(offset), true);
    }

    @Uninterruptible(reason="Prevent objects from moving.")
    private static Object readThreadLocalObject(Pointer threadLocals, int offset) {
        return VMThreadLocalInfos.readThreadLocalObjectAsWord(threadLocals, offset).toObject();
    }

    public static int getOffset(FastThreadLocal threadLocal) {
        VMThreadLocalInfos singleton = (VMThreadLocalInfos)ImageSingletons.lookup(VMThreadLocalInfos.class);
        for (VMThreadLocalInfo info : singleton.infos) {
            if (!threadLocal.getLocationIdentity().equals(info.locationIdentity)) continue;
            return info.offset;
        }
        return -1;
    }

    @Override
    public EnumSet<LayeredImageSingletonBuilderFlags> getImageBuilderFlags() {
        return LayeredImageSingletonBuilderFlags.ALL_ACCESS;
    }
}

