/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.sampler;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.util.VMError;
import jdk.graal.compiler.nodes.PauseNode;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.WordFactory;

class SamplerSpinLock {
    private final UninterruptibleUtils.AtomicPointer<IsolateThread> owner = new UninterruptibleUtils.AtomicPointer();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    SamplerSpinLock() {
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isOwner() {
        return this.owner.get().equal((ComparableWord)CurrentIsolate.getCurrentThread());
    }

    @Uninterruptible(reason="This method does not do a transition, so the whole critical section must be uninterruptible.", callerMustBe=true)
    public void lock() {
        VMError.guarantee(!this.isOwner(), "The current thread already has the lock!");
        IsolateThread currentThread = CurrentIsolate.getCurrentThread();
        while (!this.owner.compareAndSet((IsolateThread)WordFactory.nullPointer(), currentThread)) {
            PauseNode.pause();
        }
    }

    @Uninterruptible(reason="The whole critical section must be uninterruptible.", callerMustBe=true)
    public void unlock() {
        VMError.guarantee(this.isOwner(), "The current thread doesn't have the lock!");
        this.owner.compareAndSet(CurrentIsolate.getCurrentThread(), (IsolateThread)WordFactory.nullPointer());
    }
}

