/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.jdk;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.util.BasedOnJDKFile;
import com.oracle.svm.core.util.PlatformTimeUtils;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.impl.InternalPlatform;

@TargetClass(className="jdk.internal.misc.VM")
final class Target_jdk_internal_misc_VM {
    Target_jdk_internal_misc_VM() {
    }

    @Substitute
    @Platforms(value={InternalPlatform.NATIVE_ONLY.class})
    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+3/src/hotspot/share/prims/jvm.cpp#L258-L291")
    public static long getNanoTimeAdjustment(long offsetInSeconds) {
        long maxDiffSecs = 0x100000000L;
        long minDiffSecs = -maxDiffSecs;
        PlatformTimeUtils.SecondsNanos time = PlatformTimeUtils.singleton().javaTimeSystemUTC();
        long diff = time.seconds() - offsetInSeconds;
        if (diff >= maxDiffSecs || diff <= minDiffSecs) {
            return -1L;
        }
        return diff * 1000000000L + time.nanos();
    }
}

