/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.darwin;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.locks.VMSemaphore;
import com.oracle.svm.core.posix.darwin.DarwinSemaphore;
import com.oracle.svm.core.posix.headers.darwin.DarwinVirtualMemory;
import com.oracle.svm.core.posix.pthread.PthreadVMLockSupport;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;

final class DarwinVMSemaphore
extends VMSemaphore {
    private DarwinSemaphore.semaphore_t semaphore;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    DarwinVMSemaphore(String name) {
        super(name);
    }

    @Override
    @Uninterruptible(reason="Too early for safepoints.")
    public int initialize() {
        DarwinSemaphore.semaphore_tPointer semaphorePointer = (DarwinSemaphore.semaphore_tPointer)StackValue.get(DarwinSemaphore.semaphore_tPointer.class);
        int result = DarwinSemaphore.NoTransition.semaphore_create(DarwinVirtualMemory.mach_task_self(), semaphorePointer, DarwinSemaphore.SYNC_POLICY_FIFO(), 0);
        this.semaphore = semaphorePointer.read();
        return result;
    }

    @Override
    @Uninterruptible(reason="The isolate teardown is in progress.")
    public int destroy() {
        return DarwinSemaphore.NoTransition.semaphore_destroy(DarwinVirtualMemory.mach_task_self(), this.semaphore);
    }

    @Override
    public void await() {
        int result;
        while ((result = DarwinSemaphore.semaphore_wait(this.semaphore)) == DarwinSemaphore.KERN_ABORTED()) {
        }
        PthreadVMLockSupport.checkResult(result, "semaphore_wait");
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void signal() {
        PthreadVMLockSupport.checkResult(DarwinSemaphore.NoTransition.semaphore_signal(this.semaphore), "semaphore_signal");
    }
}

