/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.pltgot;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.pltgot.GOTHeapSupport;
import com.oracle.svm.core.pltgot.PLTGOTConfiguration;
import com.oracle.svm.core.thread.JavaSpinLockUtils;
import jdk.internal.misc.Unsafe;

public class MethodAddressResolutionDispatcher {
    private static final MethodAddressResolutionDispatcher dispatcher = new MethodAddressResolutionDispatcher();
    private static final long LOCK_OFFSET = Unsafe.getUnsafe().objectFieldOffset(MethodAddressResolutionDispatcher.class, "lock");
    private volatile int lock;
    private int activeResolverInstances = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="PLT/GOT method address resolution doesn't support interruptible code paths.")
    protected static long resolveMethodAddress(long gotEntry) {
        try {
            JavaSpinLockUtils.lockNoTransition(dispatcher, LOCK_OFFSET);
            if (MethodAddressResolutionDispatcher.dispatcher.activeResolverInstances == 0) {
                GOTHeapSupport.get().makeGOTWritable();
            }
            ++MethodAddressResolutionDispatcher.dispatcher.activeResolverInstances;
        }
        finally {
            JavaSpinLockUtils.unlock(dispatcher, LOCK_OFFSET);
        }
        long resolvedMethodAddress = PLTGOTConfiguration.singleton().getMethodAddressResolver().resolveMethodWithGotEntry(gotEntry);
        try {
            JavaSpinLockUtils.lockNoTransition(dispatcher, LOCK_OFFSET);
            if (MethodAddressResolutionDispatcher.dispatcher.activeResolverInstances == 1) {
                GOTHeapSupport.get().makeGOTReadOnly();
            }
            --MethodAddressResolutionDispatcher.dispatcher.activeResolverInstances;
        }
        finally {
            JavaSpinLockUtils.unlock(dispatcher, LOCK_OFFSET);
        }
        return resolvedMethodAddress;
    }
}

