/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.meta;

import com.oracle.svm.core.meta.MethodPointer;
import java.util.Objects;
import jdk.vm.ci.meta.VMConstant;

public class SubstrateMethodPointerConstant
implements VMConstant {
    private final MethodPointer pointer;
    public static final SubstrateMethodPointerConstant ALWAYS_NULL = new SubstrateMethodPointerConstant(null);

    public SubstrateMethodPointerConstant(MethodPointer pointer) {
        this.pointer = pointer;
    }

    public MethodPointer pointer() {
        return this.pointer;
    }

    public boolean isDefaultForKind() {
        return false;
    }

    public String toValueString() {
        return "SVMMethodPointerConstant";
    }

    public String toString() {
        return "method: " + (this.pointer == null ? "null" : this.pointer.getMethod().format("%H.%n"));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SubstrateMethodPointerConstant)) {
            return false;
        }
        if (this == ALWAYS_NULL) {
            return obj == ALWAYS_NULL;
        }
        if (obj == ALWAYS_NULL) {
            return this == ALWAYS_NULL;
        }
        SubstrateMethodPointerConstant that = (SubstrateMethodPointerConstant)obj;
        return this == obj || this.pointer.getMethod().equals((Object)that.pointer.getMethod());
    }

    public int hashCode() {
        return this.pointer == null ? 0 : Objects.hashCode(this.pointer.getMethod());
    }
}

