/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jfr.JfrBuffer;
import com.oracle.svm.core.jfr.JfrBufferAccess;
import com.oracle.svm.core.jfr.JfrBufferNode;
import com.oracle.svm.core.jfr.JfrBufferNodeAccess;
import com.oracle.svm.core.jfr.JfrBufferType;
import com.oracle.svm.core.thread.JavaSpinLockUtils;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.util.VMError;
import jdk.internal.misc.Unsafe;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.WordFactory;

public class JfrBufferList {
    private static final Unsafe U = Unsafe.getUnsafe();
    private static final long LOCK_OFFSET = U.objectFieldOffset(JfrBufferList.class, "lock");
    private volatile int lock;
    private JfrBufferNode head;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public JfrBufferList() {
    }

    public void teardown() {
        assert (VMOperation.isInProgressAtSafepoint());
        JfrBufferNode node = this.head;
        while (node.isNonNull()) {
            JfrBuffer buffer = JfrBufferNodeAccess.getBuffer(node);
            if (buffer.isNonNull()) {
                assert (JfrBufferAccess.isRetired(buffer));
                buffer.setNode((JfrBufferNode)WordFactory.nullPointer());
            }
            JfrBufferNode next = node.getNext();
            JfrBufferNodeAccess.free(node);
            node = next;
        }
        this.head = (JfrBufferNode)WordFactory.nullPointer();
    }

    @Uninterruptible(reason="Locking without transition requires that the whole critical section is uninterruptible.")
    public JfrBufferNode getHead() {
        this.lockNoTransition();
        try {
            JfrBufferNode jfrBufferNode = this.head;
            return jfrBufferNode;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Locking without transition requires that the whole critical section is uninterruptible.")
    public JfrBufferNode addNode(JfrBuffer buffer) {
        assert (buffer.isNonNull());
        assert (buffer.getBufferType() != null && buffer.getBufferType() != JfrBufferType.C_HEAP);
        JfrBufferNode node = JfrBufferNodeAccess.allocate(buffer);
        if (node.isNull()) {
            return (JfrBufferNode)WordFactory.nullPointer();
        }
        this.lockNoTransition();
        try {
            assert (buffer.getNode().isNull());
            buffer.setNode(node);
            node.setNext(this.head);
            this.head = node;
            JfrBufferNode jfrBufferNode = node;
            return jfrBufferNode;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Locking without transition requires that the whole critical section is uninterruptible.")
    public void removeNode(JfrBufferNode node, JfrBufferNode prev) {
        assert (this.head.isNonNull());
        this.lockNoTransition();
        try {
            assert (JfrBufferNodeAccess.getBuffer(node).isNull());
            JfrBufferNode next = node.getNext();
            if (node == this.head) {
                assert (prev.isNull());
                this.head = next;
            } else if (prev.isNonNull()) {
                assert (prev.getNext() == node);
                prev.setNext(next);
            } else {
                JfrBufferNode p = this.findPrev(node);
                assert (p.isNonNull() && p.getNext() == node);
                p.setNext(next);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Uninterruptible(reason="Locking without transition requires that the whole critical section is uninterruptible.")
    private JfrBufferNode findPrev(JfrBufferNode node) {
        JfrBufferNode cur = this.head;
        JfrBufferNode prev = (JfrBufferNode)WordFactory.nullPointer();
        while (cur.isNonNull()) {
            if (cur == node) {
                return prev;
            }
            prev = cur;
            cur = cur.getNext();
        }
        throw VMError.shouldNotReachHere("JfrBufferNode not found in JfrBufferList.");
    }

    @Uninterruptible(reason="Locking without transition requires that the whole critical section is uninterruptible.", callerMustBe=true)
    private void lockNoTransition() {
        JavaSpinLockUtils.lockNoTransition(this, LOCK_OFFSET);
    }

    @Uninterruptible(reason="Locking without transition requires that the whole critical section is uninterruptible.", callerMustBe=true)
    private void unlock() {
        JavaSpinLockUtils.unlock(this, LOCK_OFFSET);
    }
}

