/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.resources;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.jdk.resources.ResourceStorageEntryBase;
import com.oracle.svm.core.util.VMError;
import java.util.ArrayList;
import java.util.List;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class ResourceStorageEntry
extends ResourceStorageEntryBase {
    private final boolean isDirectory;
    private final boolean fromJar;
    private List<byte[]> data;

    public ResourceStorageEntry(boolean isDirectory, boolean fromJar) {
        this.isDirectory = isDirectory;
        this.fromJar = fromJar;
        this.data = List.of();
    }

    @Override
    public boolean isDirectory() {
        return this.isDirectory;
    }

    @Override
    public boolean isFromJar() {
        return this.fromJar;
    }

    @Override
    public List<byte[]> getData() {
        return this.data;
    }

    @Override
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void addData(byte[] datum) {
        ArrayList<byte[]> newData = new ArrayList<byte[]>(this.data.size() + 1);
        newData.addAll(this.data);
        newData.add(datum);
        this.data = List.copyOf(newData);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void replaceData(byte[] ... replacementData) {
        VMError.guarantee(BuildPhaseProvider.isAnalysisFinished(), "Replacing data of a resource entry before analysis finished. Register standard resource instead.");
        VMError.guarantee(!BuildPhaseProvider.isCompilationFinished(), "Trying to replace data of a resource entry after compilation finished.");
        this.data = List.of(replacementData);
    }

    @Override
    public boolean isException() {
        return false;
    }

    @Override
    public boolean hasData() {
        return true;
    }
}

