/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.IsAMD64;
import com.oracle.svm.core.jdk.NotAArch64;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import jdk.graal.compiler.replacements.nodes.BinaryMathIntrinsicNode;
import jdk.graal.compiler.replacements.nodes.UnaryMathIntrinsicNode;

@TargetClass(value=Math.class, onlyWith={NotAArch64.class})
final class Target_java_lang_Math {
    Target_java_lang_Math() {
    }

    @Substitute
    @Uninterruptible(reason="Must not contain a safepoint.")
    @SubstrateForeignCallTarget(fullyUninterruptible=true, stubCallingConvention=false)
    public static double sin(double a) {
        return UnaryMathIntrinsicNode.compute((double)a, (UnaryMathIntrinsicNode.UnaryOperation)UnaryMathIntrinsicNode.UnaryOperation.SIN);
    }

    @Substitute
    @Uninterruptible(reason="Must not contain a safepoint.")
    @SubstrateForeignCallTarget(fullyUninterruptible=true, stubCallingConvention=false)
    public static double cos(double a) {
        return UnaryMathIntrinsicNode.compute((double)a, (UnaryMathIntrinsicNode.UnaryOperation)UnaryMathIntrinsicNode.UnaryOperation.COS);
    }

    @Substitute
    @Uninterruptible(reason="Must not contain a safepoint.")
    @SubstrateForeignCallTarget(fullyUninterruptible=true, stubCallingConvention=false)
    public static double tan(double a) {
        return UnaryMathIntrinsicNode.compute((double)a, (UnaryMathIntrinsicNode.UnaryOperation)UnaryMathIntrinsicNode.UnaryOperation.TAN);
    }

    @Substitute
    @Uninterruptible(reason="Must not contain a safepoint.")
    @SubstrateForeignCallTarget(fullyUninterruptible=true, stubCallingConvention=false)
    @TargetElement(onlyWith={IsAMD64.class})
    public static double tanh(double a) {
        return UnaryMathIntrinsicNode.compute((double)a, (UnaryMathIntrinsicNode.UnaryOperation)UnaryMathIntrinsicNode.UnaryOperation.TANH);
    }

    @Substitute
    @Uninterruptible(reason="Must not contain a safepoint.")
    @SubstrateForeignCallTarget(fullyUninterruptible=true, stubCallingConvention=false)
    public static double log(double a) {
        return UnaryMathIntrinsicNode.compute((double)a, (UnaryMathIntrinsicNode.UnaryOperation)UnaryMathIntrinsicNode.UnaryOperation.LOG);
    }

    @Substitute
    @Uninterruptible(reason="Must not contain a safepoint.")
    @SubstrateForeignCallTarget(fullyUninterruptible=true, stubCallingConvention=false)
    public static double log10(double a) {
        return UnaryMathIntrinsicNode.compute((double)a, (UnaryMathIntrinsicNode.UnaryOperation)UnaryMathIntrinsicNode.UnaryOperation.LOG10);
    }

    @Substitute
    @Uninterruptible(reason="Must not contain a safepoint.")
    @SubstrateForeignCallTarget(fullyUninterruptible=true, stubCallingConvention=false)
    public static double exp(double a) {
        return UnaryMathIntrinsicNode.compute((double)a, (UnaryMathIntrinsicNode.UnaryOperation)UnaryMathIntrinsicNode.UnaryOperation.EXP);
    }

    @Substitute
    @Uninterruptible(reason="Must not contain a safepoint.")
    @SubstrateForeignCallTarget(fullyUninterruptible=true, stubCallingConvention=false)
    public static double pow(double a, double b) {
        return BinaryMathIntrinsicNode.compute((double)a, (double)b, (BinaryMathIntrinsicNode.BinaryOperation)BinaryMathIntrinsicNode.BinaryOperation.POW);
    }
}

