/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.hub;

import com.oracle.svm.core.MissingRegistrationUtils;
import com.oracle.svm.core.configure.ConditionalRuntimeValue;
import com.oracle.svm.core.configure.RuntimeConditionSet;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.PredefinedClassesSupport;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonBuilderFlags;
import com.oracle.svm.core.layeredimagesingleton.MultiLayeredImageSingleton;
import com.oracle.svm.core.layeredimagesingleton.UnsavedSingleton;
import com.oracle.svm.core.reflect.MissingReflectionRegistrationUtils;
import com.oracle.svm.core.util.ImageHeapMap;
import com.oracle.svm.core.util.VMError;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.Objects;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.impl.ConfigurationCondition;

@AutomaticallyRegisteredImageSingleton
public final class ClassForNameSupport
implements MultiLayeredImageSingleton,
UnsavedSingleton {
    private ClassLoader libGraalLoader;
    private final EconomicMap<String, ConditionalRuntimeValue<Object>> knownClasses = ImageHeapMap.create();
    private final EconomicMap<Class<?>, RuntimeConditionSet> unsafeInstantiatedClasses = ImageHeapMap.create();
    private static final Object NEGATIVE_QUERY = new Object();

    public void setLibGraalLoader(ClassLoader libGraalLoader) {
        this.libGraalLoader = libGraalLoader;
    }

    public static ClassForNameSupport singleton() {
        return (ClassForNameSupport)ImageSingletons.lookup(ClassForNameSupport.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void registerClass(Class<?> clazz) {
        this.registerClass(ConfigurationCondition.alwaysTrue(), clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void registerClass(ConfigurationCondition condition, Class<?> clazz) {
        assert (!clazz.isPrimitive()) : "primitive classes cannot be looked up by name";
        if (PredefinedClassesSupport.isPredefined(clazz)) {
            return;
        }
        EconomicMap<String, ConditionalRuntimeValue<Object>> economicMap = this.knownClasses;
        synchronized (economicMap) {
            Class<?> currentValue;
            String name = clazz.getName();
            ConditionalRuntimeValue exisingEntry = (ConditionalRuntimeValue)this.knownClasses.get((Object)name);
            Class<?> clazz2 = currentValue = exisingEntry == null ? null : (Class<?>)exisingEntry.getValueUnconditionally();
            if (currentValue instanceof Class) {
                Class currentClazz = currentValue;
                if (clazz.getClassLoader() != currentClazz.getClassLoader()) {
                    if (this.isLibGraalClass(currentClazz)) {
                        return;
                    }
                    if (this.isLibGraalClass(clazz)) {
                        currentValue = null;
                    }
                }
            }
            if (currentValue == null || currentValue == NEGATIVE_QUERY || currentValue == clazz) {
                currentValue = clazz;
                cond = ClassForNameSupport.updateConditionalValue(exisingEntry, currentValue, condition);
                this.knownClasses.put((Object)name, cond);
            } else if (currentValue instanceof Throwable) {
                cond = ClassForNameSupport.updateConditionalValue(exisingEntry, currentValue, condition);
                this.knownClasses.put((Object)name, cond);
            } else {
                throw VMError.shouldNotReachHere("Invalid Class.forName value for %s: %s\nIf the class is already registered as negative, it means that it exists but is not\naccessible through the builder class loader, and it was already registered by name (as\nnegative query) before this point. In that case, we update the map to contain the actual\nclass.\n", name, currentValue);
            }
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private boolean isLibGraalClass(Class<?> clazz) {
        return this.libGraalLoader != null && clazz.getClassLoader() == this.libGraalLoader;
    }

    public static ConditionalRuntimeValue<Object> updateConditionalValue(ConditionalRuntimeValue<Object> existingConditionalValue, Object newValue, ConfigurationCondition additionalCondition) {
        if (existingConditionalValue == null) {
            return new ConditionalRuntimeValue<Object>(RuntimeConditionSet.createHosted(additionalCondition), newValue);
        }
        existingConditionalValue.getConditions().addCondition(additionalCondition);
        existingConditionalValue.updateValue(newValue);
        return existingConditionalValue;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void registerExceptionForClass(ConfigurationCondition condition, String className, Throwable t) {
        this.updateCondition(condition, className, t);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void registerNegativeQuery(ConfigurationCondition condition, String className) {
        this.updateCondition(condition, className, NEGATIVE_QUERY);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void registerUnsafeAllocated(ConfigurationCondition condition, Class<?> clazz) {
        RuntimeConditionSet conditionSet;
        if (!clazz.isArray() && (conditionSet = (RuntimeConditionSet)this.unsafeInstantiatedClasses.putIfAbsent(clazz, (Object)RuntimeConditionSet.createHosted(condition))) != null) {
            conditionSet.addCondition(condition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCondition(ConfigurationCondition condition, String className, Object value) {
        EconomicMap<String, ConditionalRuntimeValue<Object>> economicMap = this.knownClasses;
        synchronized (economicMap) {
            ConditionalRuntimeValue runtimeConditions = (ConditionalRuntimeValue)this.knownClasses.putIfAbsent((Object)className, new ConditionalRuntimeValue<Object>(RuntimeConditionSet.createHosted(condition), value));
            if (runtimeConditions != null) {
                runtimeConditions.getConditions().addCondition(condition);
            }
        }
    }

    public static Class<?> forNameOrNull(String className, ClassLoader classLoader) {
        try {
            return ClassForNameSupport.forName(className, classLoader, true);
        }
        catch (ClassNotFoundException e) {
            throw VMError.shouldNotReachHere("ClassForNameSupport#forNameOrNull should not throw", e);
        }
    }

    public static Class<?> forName(String className, ClassLoader classLoader) throws ClassNotFoundException {
        return ClassForNameSupport.forName(className, classLoader, false);
    }

    private static Class<?> forName(String className, ClassLoader classLoader, boolean returnNullOnException) throws ClassNotFoundException {
        if (className == null) {
            return null;
        }
        ClassForNameSupport classForNameSupport = ClassForNameSupport.singleton();
        Object result = classForNameSupport.getSingletonData(classForNameSupport, (ClassForNameSupport[])MultiLayeredImageSingleton.getAllLayers(ClassForNameSupport.class), singleton -> singleton.forName0(className, classLoader));
        if (result instanceof Class) {
            return (Class)result;
        }
        if (result instanceof Throwable) {
            if (returnNullOnException) {
                return null;
            }
            if (result instanceof Error) {
                throw (Error)result;
            }
            if (result instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)result;
            }
        } else if (result == null) {
            if (MissingRegistrationUtils.throwMissingRegistrationErrors()) {
                MissingReflectionRegistrationUtils.forClass(className);
            }
            if (returnNullOnException) {
                return null;
            }
            throw new ClassNotFoundException(className);
        }
        throw VMError.shouldNotReachHere("Class.forName result should be Class, ClassNotFoundException or Error: " + String.valueOf(result));
    }

    private Object forName0(String className, ClassLoader classLoader) {
        Serializable result;
        ConditionalRuntimeValue conditional = (ConditionalRuntimeValue)this.knownClasses.get((Object)className);
        ClassNotFoundException classNotFoundException = result = conditional == null ? null : (ClassNotFoundException)conditional.getValue();
        if (result == NEGATIVE_QUERY || className.endsWith("[]")) {
            result = new ClassNotFoundException(className);
        }
        if (result == null) {
            result = PredefinedClassesSupport.getLoadedForNameOrNull(className, classLoader);
        }
        return result;
    }

    public int count() {
        return this.knownClasses.size();
    }

    public static RuntimeConditionSet getConditionFor(Class<?> jClass) {
        Objects.requireNonNull(jClass);
        String jClassName = jClass.getName();
        ClassForNameSupport classForNameSupport = ClassForNameSupport.singleton();
        ConditionalRuntimeValue conditionalClass = (ConditionalRuntimeValue)classForNameSupport.getSingletonData(classForNameSupport, (ClassForNameSupport[])MultiLayeredImageSingleton.getAllLayers(ClassForNameSupport.class), singleton -> (ConditionalRuntimeValue)singleton.knownClasses.get((Object)jClassName));
        if (conditionalClass == null) {
            return RuntimeConditionSet.unmodifiableEmptySet();
        }
        return conditionalClass.getConditions();
    }

    public static boolean canUnsafeInstantiateAsInstance(DynamicHub hub) {
        Class<?> clazz = DynamicHub.toClass(hub);
        ClassForNameSupport classForNameSupport = ClassForNameSupport.singleton();
        RuntimeConditionSet conditionSet = (RuntimeConditionSet)classForNameSupport.getSingletonData(classForNameSupport, (ClassForNameSupport[])MultiLayeredImageSingleton.getAllLayers(ClassForNameSupport.class), singleton -> (RuntimeConditionSet)singleton.unsafeInstantiatedClasses.get((Object)clazz));
        return conditionSet != null && conditionSet.satisfied();
    }

    @Override
    public EnumSet<LayeredImageSingletonBuilderFlags> getImageBuilderFlags() {
        return LayeredImageSingletonBuilderFlags.ALL_ACCESS;
    }
}

