/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.amd64;

import com.oracle.svm.core.graal.amd64.SubstrateAMD64Backend;
import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.Opcode;
import jdk.graal.compiler.lir.StandardOp;
import jdk.graal.compiler.lir.amd64.AMD64BlockEndOp;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.meta.Value;

@Opcode(value="RETURN")
public class AMD64ReturnOp
extends AMD64BlockEndOp
implements StandardOp.BlockEndOp {
    public static final LIRInstructionClass<AMD64ReturnOp> TYPE = LIRInstructionClass.create(AMD64ReturnOp.class);
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    protected Value x;

    protected AMD64ReturnOp(LIRInstructionClass<? extends AMD64BlockEndOp> type, Value x) {
        super(type);
        this.x = x;
    }

    public AMD64ReturnOp(Value x) {
        this(TYPE, x);
    }

    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        crb.frameContext.leave(crb);
        if (SubstrateAMD64Backend.runtimeToAOTIsAvxSseTransition(crb.target)) {
            masm.vzeroupper();
        }
        this.emitReturn(masm);
        crb.frameContext.returned(crb);
    }

    protected void emitReturn(AMD64MacroAssembler masm) {
        masm.ret(0);
    }
}

