/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge.graal;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.SerialGCOptions;
import com.oracle.svm.core.genscavenge.remset.RememberedSet;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateTemplates;
import com.oracle.svm.core.heap.ObjectHeader;
import com.oracle.svm.core.heap.StoredContinuation;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import java.util.Map;
import jdk.graal.compiler.api.replacements.Snippet;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.BreakpointNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.NamedLocationIdentity;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.nodes.extended.FixedValueAnchorNode;
import jdk.graal.compiler.nodes.extended.ForeignCallNode;
import jdk.graal.compiler.nodes.gc.SerialArrayRangeWriteBarrierNode;
import jdk.graal.compiler.nodes.gc.SerialWriteBarrierNode;
import jdk.graal.compiler.nodes.gc.WriteBarrierNode;
import jdk.graal.compiler.nodes.memory.address.OffsetAddressNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.nodes.type.StampTool;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.graal.compiler.replacements.Snippets;
import jdk.graal.compiler.word.Word;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.UnsignedWord;

public class BarrierSnippets
extends SubstrateTemplates
implements Snippets {
    public static final LocationIdentity CARD_REMEMBERED_SET_LOCATION = NamedLocationIdentity.mutable((String)"CardRememberedSet");
    private static final SnippetRuntime.SubstrateForeignCallDescriptor POST_WRITE_BARRIER = SnippetRuntime.findForeignCall(BarrierSnippets.class, "postWriteBarrierStub", ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, CARD_REMEMBERED_SET_LOCATION);
    private final SnippetTemplate.SnippetInfo postWriteBarrierSnippet;

    BarrierSnippets(OptionValues options, Providers providers) {
        super(options, providers);
        this.postWriteBarrierSnippet = this.snippet(providers, BarrierSnippets.class, "postWriteBarrierSnippet", new LocationIdentity[]{CARD_REMEMBERED_SET_LOCATION});
    }

    public void registerLowerings(MetaAccessProvider metaAccess, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        PostWriteBarrierLowering lowering = new PostWriteBarrierLowering(metaAccess);
        lowerings.put(SerialWriteBarrierNode.class, lowering);
        lowerings.put(SerialArrayRangeWriteBarrierNode.class, lowering);
    }

    public static void registerForeignCalls(SubstrateForeignCallsProvider provider) {
        provider.register(POST_WRITE_BARRIER);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void postWriteBarrierStub(Object object) {
        Word objectHeader = ObjectHeader.readHeaderFromObject(object);
        if (ObjectHeaderImpl.isUnalignedHeader((UnsignedWord)objectHeader)) {
            RememberedSet.get().dirtyCardForUnalignedObject(object, false);
        } else {
            RememberedSet.get().dirtyCardForAlignedObject(object, false);
        }
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native void callPostWriteBarrierStub(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Object var1);

    @Snippet
    public static void postWriteBarrierSnippet(Object object, @Snippet.ConstantParameter boolean shouldOutline, @Snippet.ConstantParameter boolean alwaysAlignedChunk, @Snippet.ConstantParameter boolean verifyOnly) {
        boolean unaligned;
        boolean needsBarrier;
        Object fixedObject = FixedValueAnchorNode.getObject((Object)object);
        Word objectHeader = ObjectHeader.readHeaderFromObject(fixedObject);
        if (SerialGCOptions.VerifyWriteBarriers.getValue().booleanValue() && alwaysAlignedChunk) {
            if (BranchProbabilityNode.probability((double)0.010000000000000009, (boolean)ObjectHeaderImpl.isUnalignedHeader((UnsignedWord)objectHeader))) {
                BreakpointNode.breakpoint();
            }
            if (BranchProbabilityNode.probability((double)0.010000000000000009, (fixedObject == null ? 1 : 0) != 0)) {
                BreakpointNode.breakpoint();
            }
            if (BranchProbabilityNode.probability((double)0.010000000000000009, (boolean)fixedObject.getClass().isArray())) {
                BreakpointNode.breakpoint();
            }
        }
        if (BranchProbabilityNode.probability((double)0.9, (!(needsBarrier = RememberedSet.get().hasRememberedSet((UnsignedWord)objectHeader)) ? 1 : 0) != 0)) {
            return;
        }
        if (shouldOutline && !verifyOnly) {
            BarrierSnippets.callPostWriteBarrierStub(POST_WRITE_BARRIER, fixedObject);
            return;
        }
        if (!alwaysAlignedChunk && BranchProbabilityNode.probability((double)0.4, (boolean)(unaligned = ObjectHeaderImpl.isUnalignedHeader((UnsignedWord)objectHeader)))) {
            RememberedSet.get().dirtyCardForUnalignedObject(fixedObject, verifyOnly);
            return;
        }
        RememberedSet.get().dirtyCardForAlignedObject(fixedObject, verifyOnly);
    }

    private class PostWriteBarrierLowering
    implements NodeLoweringProvider<WriteBarrierNode> {
        private final ResolvedJavaType storedContinuationType;

        PostWriteBarrierLowering(MetaAccessProvider metaAccess) {
            this.storedContinuationType = metaAccess.lookupJavaType(StoredContinuation.class);
        }

        @Override
        public void lower(WriteBarrierNode barrier, LoweringTool tool) {
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(BarrierSnippets.this.postWriteBarrierSnippet, barrier.graph().getGuardsStage(), tool.getLoweringStage());
            OffsetAddressNode address = (OffsetAddressNode)barrier.getAddress();
            ResolvedJavaType baseType = StampTool.typeOrNull((ValueNode)address.getBase());
            assert (baseType == null || !this.storedContinuationType.isAssignableFrom(baseType)) : "StoredContinuation should be effectively immutable and references only be written by GC";
            boolean alwaysAlignedChunk = baseType != null && !baseType.isArray() && !baseType.isJavaLangObject() && !baseType.isInterface();
            args.add("object", (Object)address.getBase());
            args.add("shouldOutline", (Object)PostWriteBarrierLowering.shouldOutline(barrier));
            args.add("alwaysAlignedChunk", (Object)alwaysAlignedChunk);
            args.add("verifyOnly", (Object)PostWriteBarrierLowering.getVerifyOnly(barrier));
            BarrierSnippets.this.template((CoreProviders)tool, (ValueNode)barrier, args).instantiate(tool.getMetaAccess(), (FixedNode)barrier, SnippetTemplate.DEFAULT_REPLACER, args);
        }

        private static boolean shouldOutline(WriteBarrierNode barrier) {
            if (SerialGCOptions.OutlineWriteBarriers.getValue() != null) {
                return SerialGCOptions.OutlineWriteBarriers.getValue();
            }
            return (Boolean)GraalOptions.ReduceCodeSize.getValue(barrier.getOptions());
        }

        private static boolean getVerifyOnly(WriteBarrierNode barrier) {
            if (barrier instanceof SerialWriteBarrierNode) {
                return ((SerialWriteBarrierNode)barrier).getVerifyOnly();
            }
            return false;
        }
    }
}

