/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.configure;

import com.oracle.svm.core.configure.ConfigurationTypeDescriptor;
import com.oracle.svm.core.reflect.proxy.DynamicProxySupport;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import jdk.graal.compiler.util.json.JsonPrinter;
import jdk.graal.compiler.util.json.JsonWriter;

public record ProxyConfigurationTypeDescriptor(List<String> interfaceNames) implements ConfigurationTypeDescriptor
{
    public ProxyConfigurationTypeDescriptor(List<String> interfaceNames) {
        this.interfaceNames = interfaceNames.stream().map(ConfigurationTypeDescriptor::checkQualifiedJavaName).toList();
    }

    @Override
    public ConfigurationTypeDescriptor.Kind getDescriptorType() {
        return ConfigurationTypeDescriptor.Kind.PROXY;
    }

    @Override
    public String toString() {
        return DynamicProxySupport.proxyTypeDescriptor((String[])this.interfaceNames.toArray(String[]::new));
    }

    @Override
    public Collection<String> getAllQualifiedJavaNames() {
        return this.interfaceNames;
    }

    @Override
    public int compareTo(ConfigurationTypeDescriptor other) {
        if (other instanceof ProxyConfigurationTypeDescriptor) {
            ProxyConfigurationTypeDescriptor proxyOther = (ProxyConfigurationTypeDescriptor)other;
            return Arrays.compare((Comparable[])((String[])this.interfaceNames.toArray(String[]::new)), (Comparable[])((String[])proxyOther.interfaceNames.toArray(String[]::new)));
        }
        return this.getDescriptorType().compareTo(other.getDescriptorType());
    }

    public void printJson(JsonWriter writer) throws IOException {
        writer.appendObjectStart();
        writer.quote("proxy").appendFieldSeparator();
        JsonPrinter.printCollection((JsonWriter)writer, this.interfaceNames, null, (p, w) -> w.quote(p));
        writer.appendObjectEnd();
    }
}

