/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.code.CodeInfoEncoder;
import com.oracle.svm.core.code.FrameInfoDecoder;
import com.oracle.svm.core.code.FrameInfoEncoder;
import com.oracle.svm.core.hub.DynamicHub;
import java.lang.module.ModuleDescriptor;
import java.util.Optional;
import jdk.graal.compiler.nodes.FrameState;
import jdk.internal.loader.BuiltinClassLoader;

public abstract class FrameSourceInfo {
    public static final int LINENUMBER_UNKNOWN = -1;
    public static final int LINENUMBER_NATIVE = -2;
    protected Class<?> sourceClass;
    protected String sourceMethodName;
    protected int sourceLineNumber;
    protected long encodedBci;

    protected FrameSourceInfo(Class<?> sourceClass, String sourceMethodName, int sourceLineNumber, int bci) {
        this.sourceClass = sourceClass;
        this.sourceMethodName = sourceMethodName;
        this.sourceLineNumber = sourceLineNumber;
        this.encodedBci = FrameInfoEncoder.encodeBci(bci, FrameState.StackState.BeforePop);
    }

    protected FrameSourceInfo() {
        this.init();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected void init() {
        this.sourceClass = CodeInfoEncoder.Encoders.INVALID_CLASS;
        this.sourceMethodName = "";
        this.sourceLineNumber = -1;
        this.encodedBci = -1L;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Class<?> getSourceClass() {
        this.fillSourceFieldsIfMissing();
        return this.sourceClass;
    }

    public String getSourceClassName() {
        Class<?> clazz = this.getSourceClass();
        return clazz != null ? clazz.getName() : "";
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public String getSourceMethodName() {
        this.fillSourceFieldsIfMissing();
        return this.sourceMethodName;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getSourceLineNumber() {
        return this.sourceLineNumber;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public String getSourceFileName() {
        Class<?> clazz = this.getSourceClass();
        return clazz != null ? DynamicHub.fromClass(clazz).getSourceFileName() : null;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected abstract void fillSourceFieldsIfMissing();

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getBci() {
        return FrameInfoDecoder.decodeBci(this.encodedBci);
    }

    public boolean isNativeMethod() {
        return this.sourceLineNumber == -2;
    }

    public StackTraceElement getSourceReference() {
        this.fillSourceFieldsIfMissing();
        if (this.sourceClass == null) {
            return new StackTraceElement("", this.getSourceMethodName(), null, this.getSourceLineNumber());
        }
        return FrameSourceInfo.getSourceReference(this.getSourceClass(), this.getSourceMethodName(), this.getSourceLineNumber());
    }

    public static StackTraceElement getSourceReference(Class<?> sourceClass, String sourceMethodName, int sourceLineNumber) {
        ClassLoader classLoader = sourceClass.getClassLoader();
        String classLoaderName = null;
        if (classLoader != null && !(classLoader instanceof BuiltinClassLoader)) {
            classLoaderName = classLoader.getName();
        }
        Module module = sourceClass.getModule();
        String moduleName = module.getName();
        String moduleVersion = Optional.ofNullable(module.getDescriptor()).flatMap(ModuleDescriptor::version).map(ModuleDescriptor.Version::toString).orElse(null);
        String className = sourceClass.getName();
        String sourceFileName = DynamicHub.fromClass(sourceClass).getSourceFileName();
        return new StackTraceElement(classLoaderName, moduleName, moduleVersion, className, sourceMethodName, sourceFileName, sourceLineNumber);
    }
}

