/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.option.OptionClassFilter;
import jdk.graal.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class MissingRegistrationSupport {
    private final OptionClassFilter classFilter;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public MissingRegistrationSupport(OptionClassFilter classFilter) {
        this.classFilter = classFilter;
    }

    @Fold
    public static MissingRegistrationSupport singleton() {
        return (MissingRegistrationSupport)ImageSingletons.lookup(MissingRegistrationSupport.class);
    }

    public boolean reportMissingRegistrationErrors(StackTraceElement responsibleClass) {
        return this.reportMissingRegistrationErrors(responsibleClass.getModuleName(), MissingRegistrationSupport.getPackageName(responsibleClass.getClassName()), responsibleClass.getClassName());
    }

    public boolean reportMissingRegistrationErrors(Class<?> clazz) {
        return this.reportMissingRegistrationErrors(clazz.getModule().getName(), clazz.getPackageName(), clazz.getName());
    }

    private boolean reportMissingRegistrationErrors(String moduleName, String packageName, String className) {
        return this.classFilter.isIncluded(moduleName, packageName, className) != null;
    }

    private static String getPackageName(String className) {
        int lastDot = className.lastIndexOf(46);
        return lastDot != -1 ? className.substring(0, lastDot) : "";
    }
}

