/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.reachability;

import com.oracle.graal.pointsto.ObjectScanner;
import com.oracle.graal.pointsto.ObjectScanningObserver;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisType;
import jdk.vm.ci.meta.JavaConstant;

public class ReachabilityObjectScanner
implements ObjectScanningObserver {
    private final AnalysisMetaAccess access;

    public ReachabilityObjectScanner(AnalysisMetaAccess access) {
        this.access = access;
    }

    public boolean forRelocatedPointerFieldValue(JavaConstant receiver, AnalysisField field, JavaConstant fieldValue, ObjectScanner.ScanReason reason) {
        if (!field.isWritten()) {
            return field.registerAsWritten((Object)reason);
        }
        return false;
    }

    public boolean forNullFieldValue(JavaConstant receiver, AnalysisField field, ObjectScanner.ScanReason reason) {
        boolean modified = false;
        if (receiver != null) {
            modified = this.constantType(receiver).registerAsReachable((Object)reason);
        }
        return modified | field.getType().registerAsReachable((Object)reason);
    }

    public boolean forNonNullFieldValue(JavaConstant receiver, AnalysisField field, JavaConstant fieldValue, ObjectScanner.ScanReason reason) {
        boolean modified = false;
        if (receiver != null) {
            modified = this.constantType(receiver).registerAsInstantiated((Object)reason);
        }
        return modified | field.getType().registerAsReachable((Object)reason);
    }

    public boolean forNullArrayElement(JavaConstant array, AnalysisType arrayType, int elementIndex, ObjectScanner.ScanReason reason) {
        return arrayType.registerAsReachable((Object)reason);
    }

    public boolean forNonNullArrayElement(JavaConstant array, AnalysisType arrayType, JavaConstant elementConstant, AnalysisType elementType, int elementIndex, ObjectScanner.ScanReason reason) {
        return arrayType.registerAsReachable((Object)reason) | elementType.registerAsInstantiated((Object)reason);
    }

    public void forEmbeddedRoot(JavaConstant root, ObjectScanner.ScanReason reason) {
        this.constantType(root).registerAsReachable((Object)reason);
        this.constantType(root).registerAsInstantiated((Object)reason);
    }

    public void forScannedConstant(JavaConstant scannedValue, ObjectScanner.ScanReason reason) {
        AnalysisType type = this.constantType(scannedValue);
        type.registerAsInstantiated((Object)reason);
    }

    private AnalysisType constantType(JavaConstant constant) {
        return this.access.lookupJavaType(constant);
    }
}

