/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.truffle;

import com.oracle.graal.compiler.enterprise.q;
import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.enterprise.truffle.EnterpriseTruffleBaseFeature;
import com.oracle.svm.enterprise.truffle.e;
import com.oracle.svm.enterprise.truffle.h;
import com.oracle.svm.enterprise.truffle.x;
import com.oracle.svm.graal.hosted.runtimecompilation.RuntimeCompilationFeature;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.truffle.TruffleFeature;
import com.oracle.svm.truffle.TruffleSupport;
import java.util.List;
import java.util.function.BooleanSupplier;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugins;
import jdk.graal.compiler.nodes.spi.Replacements;
import jdk.graal.compiler.phases.util.Providers;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

public final class EnterpriseTruffleFeature
implements InternalFeature {
    static boolean k() {
        return ImageSingletons.contains(EnterpriseTruffleFeature.class);
    }

    public String getDescription() {
        return "Provides enterprise extensions for Truffle runtime compilation";
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess isInConfigurationAccess) {
        return TruffleFeature.isInConfiguration() && isInConfigurationAccess.findClassByName("com.oracle.truffle.runtime.enterprise.EnterpriseTruffle") != null;
    }

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return List.of(EnterpriseTruffleBaseFeature.class, TruffleFeature.class);
    }

    public void afterRegistration(Feature.AfterRegistrationAccess afterRegistrationAccess) {
        if (!EnterpriseTruffleFeature.k()) {
            return;
        }
        ImageSingletons.add(TruffleSupport.class, (Object)((Object)new h()));
        e.h();
    }

    public void registerInvocationPlugins(Providers providers, GraphBuilderConfiguration.Plugins plugins, ParsingReason parsingReason) {
        Architecture architecture = providers.getLowerer().getTarget().arch;
        if (architecture instanceof AMD64 || architecture instanceof AArch64) {
            q.a((Architecture)architecture, (InvocationPlugins)plugins.getInvocationPlugins(), (Replacements)providers.getReplacements());
        }
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess beforeAnalysisAccess) {
        if (!EnterpriseTruffleFeature.k()) {
            return;
        }
        FeatureImpl.BeforeAnalysisAccessImpl beforeAnalysisAccessImpl = (FeatureImpl.BeforeAnalysisAccessImpl)beforeAnalysisAccess;
        x.a((MetaAccessProvider)beforeAnalysisAccessImpl.getMetaAccess());
        x.singleton().b(beforeAnalysisAccessImpl);
        x.singleton().a((Feature.BeforeAnalysisAccess)beforeAnalysisAccessImpl);
        RuntimeCompilationFeature runtimeCompilationFeature = RuntimeCompilationFeature.singleton();
        for (ResolvedJavaMethod resolvedJavaMethod : x.singleton().aj.values()) {
            runtimeCompilationFeature.prepareMethodForRuntimeCompilation(resolvedJavaMethod, beforeAnalysisAccessImpl);
        }
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess beforeCompilationAccess) {
        if (!EnterpriseTruffleFeature.k()) {
            return;
        }
        x x2 = x.singleton();
        x2.a((Feature.CompilationAccess)beforeCompilationAccess);
        beforeCompilationAccess.registerAsImmutable((Object)x2);
    }

    static final class a
    implements BooleanSupplier {
        a() {
        }

        @Override
        public boolean getAsBoolean() {
            return EnterpriseTruffleFeature.k();
        }
    }
}

