/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.profiling.profiles;

import com.oracle.svm.enterprise.profiling.collect.e;
import com.oracle.svm.enterprise.profiling.data.l;
import com.oracle.svm.enterprise.profiling.data.m;
import com.oracle.svm.enterprise.profiling.kinds.c;
import com.oracle.svm.enterprise.profiling.kinds.d;
import com.oracle.svm.enterprise.profiling.loaders.ProfilingLoader;
import com.oracle.svm.enterprise.profiling.metadata.a;
import com.oracle.svm.enterprise.profiling.metadata.b;
import com.oracle.svm.enterprise.profiling.o;
import com.oracle.svm.enterprise.profiling.p;
import com.oracle.svm.util.LogUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jdk.graal.compiler.util.json.JsonBuilder;
import jdk.graal.compiler.util.json.JsonWriter;
import org.graalvm.collections.Pair;
import org.graalvm.nativeimage.ImageSingletons;

public abstract class ProfilingBaseProfile {
    protected l profilingData;
    protected a profilingMetadata;

    protected ProfilingBaseProfile() {
    }

    protected ProfilingBaseProfile(a a2, l l2) {
        this.profilingMetadata = a2;
        this.profilingData = l2;
    }

    public ProfilingBaseProfile normalize(long l2) {
        List<Map<String, com.oracle.svm.enterprise.profiling.metadata.cctree.c>> list = this.findAllNodesWithStringContext();
        long l3 = this.findSums(list.get(d.zJ.iK()));
        double d2 = (double)l2 / (double)l3;
        for (Map<String, com.oracle.svm.enterprise.profiling.metadata.cctree.c> map : list) {
            map.forEach((string, c2) -> c2.a(this.profilingData, d2));
        }
        return this;
    }

    public ProfilingBaseProfile merge(ProfilingBaseProfile profilingBaseProfile) {
        m m2 = new m();
        b b2 = new b();
        this.merge0(b2, m2);
        profilingBaseProfile.merge0(b2, m2);
        return this.newInstance(b2.iS(), m2);
    }

    public void dump(OutputStream outputStream) throws IOException {
        try (JsonWriter jsonWriter = new JsonWriter((Writer)new PrintWriter(outputStream));
             JsonBuilder.ObjectBuilder objectBuilder = jsonWriter.objectBuilder();){
            objectBuilder.append("version", (Object)"0.4.0");
            try (Object object = objectBuilder.append("types").array();){
                this.profilingMetadata.iO().a((JsonBuilder.ArrayBuilder)object);
            }
            object = objectBuilder.append("methods").array();
            try {
                this.profilingMetadata.iP().a((JsonBuilder.ArrayBuilder)object);
            }
            finally {
                if (object != null) {
                    object.close();
                }
            }
            object = this.findLeafNodes();
            for (d d2 : d.values()) {
                try (JsonBuilder.ArrayBuilder arrayBuilder = objectBuilder.append(d2.getName()).array();){
                    if (d2.iK() == d.zL.iK() && ((List)object.get(d2.iK())).isEmpty()) {
                        if (!ImageSingletons.contains(o.class)) continue;
                        ProfilingBaseProfile.dumpSamples(o.singleton().im(), arrayBuilder);
                        continue;
                    }
                    this.dump((List)object.get(d2.iK()), arrayBuilder);
                }
            }
        }
    }

    protected <T, M> a buildMetadata(ProfilingLoader<T, M> profilingLoader, e e2, com.oracle.svm.enterprise.profiling.adapters.b<T, M> b2) {
        b b3 = new b();
        b3.a(profilingLoader.getGlobalTypes());
        b3.b(profilingLoader.getGlobalMethods());
        for (Map.Entry<Byte, List<com.oracle.svm.enterprise.profiling.collect.d>> entry : e2.iE().iv().entrySet()) {
            profilingLoader.loadNodes(b3, this.profilingData, entry.getValue(), entry.getKey(), b2);
        }
        return b3.iS();
    }

    protected <T, M> void assimilate(ProfilingLoader<T, M> profilingLoader, com.oracle.svm.enterprise.profiling.adapters.b<T, M> b2, e e2, boolean bl2, boolean bl3) {
        long l2 = 0L;
        long l3 = 0L;
        com.oracle.svm.enterprise.profiling.collect.c c3 = e2.iD();
        Map<Integer, com.oracle.svm.enterprise.profiling.metadata.elements.d> map = c3.iz().stream().collect(Collectors.toMap(com.oracle.svm.enterprise.profiling.metadata.elements.d::jj, d2 -> d2));
        Map<Integer, com.oracle.svm.enterprise.profiling.metadata.elements.c> map2 = c3.fb().stream().collect(Collectors.toMap(com.oracle.svm.enterprise.profiling.metadata.elements.d::jj, c2 -> c2));
        Map<Integer, T> map3 = profilingLoader.loadTypes(map);
        Map<Integer, M> map4 = profilingLoader.loadMethods(map, map2);
        for (Map.Entry<Byte, List<com.oracle.svm.enterprise.profiling.collect.d>> entry : e2.iE().iv().entrySet()) {
            l2 += (long)entry.getValue().size();
            List<com.oracle.svm.enterprise.profiling.collect.d> list = ProfilingBaseProfile.assimilate0(entry.getValue(), b2, map, map3, map2, map4, bl2, entry.getKey());
            l3 += (long)list.size();
            entry.setValue(list);
        }
        if (bl3) {
            this.updateProfileQuality(l3, l2);
        }
    }

    protected void updateProfileQuality(long l2, long l3) {
    }

    protected abstract ProfilingBaseProfile newInstance(a var1, m var2);

    private void dump(List<com.oracle.svm.enterprise.profiling.metadata.cctree.c> list, JsonBuilder.ArrayBuilder arrayBuilder) throws IOException {
        for (com.oracle.svm.enterprise.profiling.metadata.cctree.c c2 : list) {
            long[] lArray;
            String string = ProfilingBaseProfile.makeContext(c2);
            c c3 = c2.iW();
            if (c3.h(lArray = c2.a(this.profilingData)) <= 0L) continue;
            ProfilingBaseProfile.dumpRecords(arrayBuilder.nextEntry(), string, lArray);
        }
    }

    private static String makeContext(com.oracle.svm.enterprise.profiling.metadata.cctree.c c2) {
        StringBuilder stringBuilder = new StringBuilder();
        com.oracle.svm.enterprise.profiling.metadata.cctree.d d2 = c2;
        do {
            com.oracle.svm.enterprise.profiling.metadata.codepositions.a<?> a2 = d2.iY();
            stringBuilder.insert(0, a2.getBCI()).insert(0, ":").insert(0, a2.getMethod());
            if (d2.ja() == null) continue;
            stringBuilder.insert(0, "<");
        } while ((d2 = d2.ja()) != null);
        return stringBuilder.toString();
    }

    private static void dumpSamples(Map<String, long[]> map, JsonBuilder.ArrayBuilder arrayBuilder) throws IOException {
        c c2 = d.zL.iL();
        for (Map.Entry<String, long[]> entry : map.entrySet()) {
            String string = entry.getKey();
            long[] lArray = entry.getValue();
            if (c2.h(lArray) <= 0L) continue;
            ProfilingBaseProfile.dumpRecords(arrayBuilder.nextEntry(), string, lArray);
        }
    }

    private static void dumpRecords(JsonBuilder.ValueBuilder valueBuilder, String string, long[] lArray) throws IOException {
        try (JsonBuilder.ObjectBuilder objectBuilder = valueBuilder.object();){
            objectBuilder.append("ctx", (Object)string);
            try (JsonBuilder.ArrayBuilder arrayBuilder = objectBuilder.append("records").array();){
                for (long l2 : lArray) {
                    arrayBuilder.append((Object)l2);
                }
            }
        }
    }

    private long findSums(Map<String, com.oracle.svm.enterprise.profiling.metadata.cctree.c> map) {
        long l2 = 0L;
        for (com.oracle.svm.enterprise.profiling.metadata.cctree.c c2 : map.values()) {
            l2 += c2.b(this.profilingData);
        }
        return l2;
    }

    private void merge0(b b2, l l2) {
        this.mergeTypes(b2);
        this.mergeNodes(b2, l2);
    }

    private void mergeTypes(b b2) {
        b2.a(this.profilingMetadata.iO());
        b2.b(this.profilingMetadata.iP());
    }

    private void mergeNodes(b b2, l l2) {
        List<Map<List<com.oracle.svm.enterprise.profiling.metadata.codepositions.a<?>>, com.oracle.svm.enterprise.profiling.metadata.cctree.c>> list = this.findAllNodes();
        for (Map<List<com.oracle.svm.enterprise.profiling.metadata.codepositions.a<?>>, com.oracle.svm.enterprise.profiling.metadata.cctree.c> map : list) {
            for (Map.Entry<List<com.oracle.svm.enterprise.profiling.metadata.codepositions.a<?>>, com.oracle.svm.enterprise.profiling.metadata.cctree.c> entry : map.entrySet()) {
                com.oracle.svm.enterprise.profiling.metadata.cctree.c c2 = entry.getValue();
                long[] lArray = c2.a(this.profilingData);
                List<com.oracle.svm.enterprise.profiling.metadata.codepositions.a<?>> list2 = entry.getKey();
                byte by = d.a(c2.iW());
                com.oracle.svm.enterprise.profiling.metadata.cctree.e e2 = b2.m(list2);
                com.oracle.svm.enterprise.profiling.metadata.cctree.d d2 = e2.jc();
                if (e2.jd() && d2 instanceof com.oracle.svm.enterprise.profiling.metadata.cctree.c) {
                    com.oracle.svm.enterprise.profiling.metadata.cctree.c c3 = (com.oracle.svm.enterprise.profiling.metadata.cctree.c)d2;
                    c3.a(l2, lArray);
                    continue;
                }
                int n2 = l2.W(lArray.length);
                l2.a(n2, lArray);
                b2.a(list2, by, n2);
            }
        }
    }

    private static <T, M> List<com.oracle.svm.enterprise.profiling.collect.d> assimilate0(List<com.oracle.svm.enterprise.profiling.collect.d> list, com.oracle.svm.enterprise.profiling.adapters.b<T, M> b2, Map<Integer, com.oracle.svm.enterprise.profiling.metadata.elements.d> map, Map<Integer, T> map2, Map<Integer, com.oracle.svm.enterprise.profiling.metadata.elements.c> map3, Map<Integer, M> map4, boolean bl2, byte by) {
        ArrayList<com.oracle.svm.enterprise.profiling.collect.d> arrayList = new ArrayList<com.oracle.svm.enterprise.profiling.collect.d>();
        d d2 = d.e(by);
        for (com.oracle.svm.enterprise.profiling.collect.d d3 : list) {
            d3.b(d2.iL().a(d3.iA(), b2, map2));
            if (d2.iL().h(d3.iA()) <= 0L) continue;
            if (ProfilingBaseProfile.checkCallingContext(d3, b2, map4)) {
                arrayList.add(d3);
                continue;
            }
            if (!bl2) continue;
            ProfilingBaseProfile.printDroppedContexts(d3.iB(), d2.getName(), map, map3, map4);
        }
        return arrayList;
    }

    private static <T, M> boolean checkCallingContext(com.oracle.svm.enterprise.profiling.collect.d d2, com.oracle.svm.enterprise.profiling.adapters.b<T, M> b2, Map<Integer, M> map) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : p.U(d2.iB())) {
            Pair<Integer, Integer> pair = p.T(string);
            int n2 = 0;
            if ((Integer)pair.getLeft() != 0) {
                M m2 = map.get(pair.getLeft());
                if (m2 == null) {
                    return false;
                }
                n2 = b2.m(m2);
            }
            arrayList.add(p.c(n2, (Integer)pair.getRight()));
        }
        d2.V(String.join((CharSequence)"<", arrayList));
        return true;
    }

    private static <M> void printDroppedContexts(String string, String string2, Map<Integer, com.oracle.svm.enterprise.profiling.metadata.elements.d> map, Map<Integer, com.oracle.svm.enterprise.profiling.metadata.elements.c> map2, Map<Integer, M> map3) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = true;
        for (String string3 : p.U(string)) {
            Object object;
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append("<-");
            }
            Pair<Integer, Integer> pair = p.T(string3);
            Integer n2 = (Integer)pair.getLeft();
            com.oracle.svm.enterprise.profiling.metadata.elements.c c2 = map2.get(n2);
            String string4 = "unknown type";
            String string5 = "unknown method";
            if (c2 != null) {
                string5 = c2.getName();
                object = map.get(c2.jk()[0]);
                if (object != null) {
                    string4 = ((com.oracle.svm.enterprise.profiling.metadata.elements.d)object).getName();
                }
            }
            object = map3.get(n2) == null ? "?" : "";
            stringBuilder.append(string4).append("#").append(string5).append(':').append(pair.getRight()).append((String)object);
        }
        LogUtils.warning((String)"Dropping calling-context for %s (? missing method) %s.".formatted(string2, stringBuilder.toString()));
    }

    private List<Map<List<com.oracle.svm.enterprise.profiling.metadata.codepositions.a<?>>, com.oracle.svm.enterprise.profiling.metadata.cctree.c>> findAllNodes() {
        return this.profilingMetadata.a((list, a2) -> {
            ArrayList<com.oracle.svm.enterprise.profiling.metadata.codepositions.a> arrayList = new ArrayList<com.oracle.svm.enterprise.profiling.metadata.codepositions.a>((Collection<com.oracle.svm.enterprise.profiling.metadata.codepositions.a>)list);
            arrayList.add((com.oracle.svm.enterprise.profiling.metadata.codepositions.a)a2);
            return arrayList;
        }, ArrayList::new);
    }

    private List<Map<String, com.oracle.svm.enterprise.profiling.metadata.cctree.c>> findAllNodesWithStringContext() {
        return this.profilingMetadata.a((string, a2) -> {
            Object object = p.c(a2.getMethod(), a2.getBCI());
            if (!string.isEmpty()) {
                object = string + "<" + (String)object;
            }
            return object;
        }, () -> "");
    }

    private List<List<com.oracle.svm.enterprise.profiling.metadata.cctree.c>> findLeafNodes() {
        return this.profilingMetadata.findLeafNodes();
    }
}

