/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.profiling.framework.collection;

import com.oracle.svm.enterprise.profiling.framework.collection.CodePosition;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public abstract class CallingContext {
    public static CallingContext empty() {
        return EmptyCallingContext.INSTANCE;
    }

    public static CallingContext create(List<CodePosition> list) {
        return new ArrayBackedCallingContext(list);
    }

    public static CallingContext withCallee(CodePosition codePosition, CallingContext callingContext) {
        return new PrependedHeadTailCallingContext(codePosition, callingContext);
    }

    public static CallingContext withCaller(CallingContext callingContext, CodePosition codePosition) {
        return new AppendedHeadTailCallingContext(codePosition, callingContext);
    }

    public abstract void traverseFromCallee(Consumer<CodePosition> var1);

    public abstract CallingContext tail();

    public abstract CodePosition head();

    public abstract boolean isEmpty();

    private static class EmptyCallingContext
    extends CallingContext {
        private static final CallingContext INSTANCE = new EmptyCallingContext();

        private EmptyCallingContext() {
        }

        private static IndexOutOfBoundsException indexOutOfBounds() {
            return new IndexOutOfBoundsException("Operation not allowed on empty calling context");
        }

        @Override
        public void traverseFromCallee(Consumer<CodePosition> consumer) {
        }

        @Override
        public CallingContext tail() {
            throw EmptyCallingContext.indexOutOfBounds();
        }

        @Override
        public CodePosition head() {
            throw EmptyCallingContext.indexOutOfBounds();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }
    }

    private static final class ArrayBackedCallingContext
    extends CallingContext {
        private final CodePosition[] context;
        private final int offset;

        private ArrayBackedCallingContext(List<CodePosition> list) {
            this.context = (CodePosition[])list.toArray(CodePosition[]::new);
            this.offset = 0;
        }

        private ArrayBackedCallingContext(CodePosition[] codePositionArray, int n2) {
            if (n2 < 0 || n2 >= codePositionArray.length) {
                throw new IllegalArgumentException();
            }
            this.context = codePositionArray;
            this.offset = n2;
        }

        @Override
        public void traverseFromCallee(Consumer<CodePosition> consumer) {
            for (int i2 = this.offset; i2 < this.context.length; ++i2) {
                consumer.accept(this.context[i2]);
            }
        }

        @Override
        public CallingContext tail() {
            int n2 = this.offset + 1;
            if (n2 >= this.context.length) {
                return ArrayBackedCallingContext.empty();
            }
            return new ArrayBackedCallingContext(this.context, n2);
        }

        @Override
        public CodePosition head() {
            if (this.context.length == 0) {
                throw EmptyCallingContext.indexOutOfBounds();
            }
            return this.context[this.offset];
        }

        @Override
        public boolean isEmpty() {
            return this.context.length - this.offset == 0;
        }

        public String toString() {
            return "CallingContext{context=" + Arrays.toString(this.context) + ", offset=" + this.offset + "}";
        }
    }

    private static final class PrependedHeadTailCallingContext
    extends CallingContext {
        private final CodePosition position;
        private final CallingContext tail;

        private PrependedHeadTailCallingContext(CodePosition codePosition, CallingContext callingContext) {
            this.position = codePosition;
            Objects.requireNonNull(callingContext, "Tail should not be null, use CallingContext.empty instead");
            this.tail = callingContext;
        }

        @Override
        public void traverseFromCallee(Consumer<CodePosition> consumer) {
            consumer.accept(this.position);
            this.tail.traverseFromCallee(consumer);
        }

        @Override
        public CallingContext tail() {
            return this.tail;
        }

        @Override
        public CodePosition head() {
            return this.position;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }
    }

    private static class AppendedHeadTailCallingContext
    extends CallingContext {
        private final CodePosition position;
        private final CallingContext tail;

        AppendedHeadTailCallingContext(CodePosition codePosition, CallingContext callingContext) {
            this.position = codePosition;
            this.tail = callingContext;
        }

        @Override
        public void traverseFromCallee(Consumer<CodePosition> consumer) {
            this.tail.traverseFromCallee(consumer);
            consumer.accept(this.position);
        }

        @Override
        public CallingContext tail() {
            throw new UnsupportedOperationException();
        }

        @Override
        public CodePosition head() {
            return this.position;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }
    }
}

