/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.profilingframework;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.enterprise.profiling.framework.Metadata;
import com.oracle.svm.enterprise.profiling.framework.ProfileDumper;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.image.NativeImageCodeCache;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedType;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Comparator;
import jdk.graal.compiler.code.CompilationResult;
import jdk.graal.compiler.code.SourceMapping;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.util.json.JsonBuilder;
import jdk.graal.compiler.util.json.JsonWriter;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Pair;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class a
implements InternalFeature {
    public static final String wX = "0.0.1";

    public boolean isInConfiguration(Feature.IsInConfigurationAccess isInConfigurationAccess) {
        return a.PGOPerfSourceMappings.hasBeenSet() && a.PGOPerfSourceMappings.getValue() != null && !((String)a.PGOPerfSourceMappings.getValue()).isEmpty();
    }

    public void beforeImageWrite(Feature.BeforeImageWriteAccess beforeImageWriteAccess) {
        FeatureImpl.BeforeImageWriteAccessImpl beforeImageWriteAccessImpl = (FeatureImpl.BeforeImageWriteAccessImpl)beforeImageWriteAccess;
        NativeImageCodeCache nativeImageCodeCache = beforeImageWriteAccessImpl.getImage().getCodeCache();
        try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter(new FileOutputStream((String)a.PGOPerfSourceMappings.getValue()));){
            a.a(nativeImageCodeCache, outputStreamWriter);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private static void a(NativeImageCodeCache nativeImageCodeCache, OutputStreamWriter outputStreamWriter) throws IOException {
        try (JsonBuilder.ObjectBuilder objectBuilder = new JsonWriter((Writer)outputStreamWriter).objectBuilder();){
            Metadata.Builder builder = new Metadata.Builder();
            a.a(nativeImageCodeCache, objectBuilder, builder);
            a.a(builder.build(), objectBuilder);
            a.dumpVersion(objectBuilder);
        }
    }

    private static void dumpVersion(JsonBuilder.ObjectBuilder objectBuilder) throws IOException {
        objectBuilder.append("version", (Object)wX);
    }

    private static void a(Metadata metadata, JsonBuilder.ObjectBuilder objectBuilder) throws IOException {
        try (JsonBuilder.ObjectBuilder objectBuilder2 = objectBuilder.append("metadata").object();){
            ProfileDumper.dumpTypes(objectBuilder2, metadata.types());
            ProfileDumper.dumpMethods(objectBuilder2, metadata.methods());
        }
    }

    private static void a(NativeImageCodeCache nativeImageCodeCache, JsonBuilder.ObjectBuilder objectBuilder, Metadata.Builder builder) throws IOException {
        try (JsonBuilder.ArrayBuilder arrayBuilder = objectBuilder.append("sourceMappings").array();){
            for (Pair pair : nativeImageCodeCache.getOrderedCompilations()) {
                HostedMethod hostedMethod = (HostedMethod)pair.getLeft();
                CompilationResult compilationResult = (CompilationResult)pair.getRight();
                JsonBuilder.ObjectBuilder objectBuilder2 = arrayBuilder.nextEntry().object();
                try {
                    a.a(hostedMethod, compilationResult, objectBuilder2, builder);
                }
                finally {
                    if (objectBuilder2 == null) continue;
                    objectBuilder2.close();
                }
            }
        }
    }

    private static void a(HostedMethod hostedMethod, CompilationResult compilationResult, JsonBuilder.ObjectBuilder objectBuilder, Metadata.Builder builder) throws IOException {
        a.a(hostedMethod, builder);
        a.a(objectBuilder, hostedMethod);
        try (JsonBuilder.ArrayBuilder arrayBuilder = objectBuilder.append("mappings").array();){
            ArrayList<SourceMapping> arrayList = new ArrayList<SourceMapping>(compilationResult.getSourceMappings());
            arrayList.sort(Comparator.comparingInt(SourceMapping::getStartOffset));
            for (SourceMapping sourceMapping : arrayList) {
                if (sourceMapping.getSourcePosition() == null) continue;
                a.a(sourceMapping, arrayBuilder, builder);
            }
        }
    }

    private static void a(HostedMethod hostedMethod, Metadata.Builder builder) {
        builder.add(hostedMethod);
        builder.add(hostedMethod.getDeclaringClass());
        builder.add((HostedType)hostedMethod.getSignature().getReturnType());
        for (int i2 = 0; i2 < hostedMethod.getSignature().getParameterCount(false); ++i2) {
            HostedType hostedType = (HostedType)hostedMethod.getSignature().getParameterType(i2);
            builder.add(hostedType);
        }
    }

    private static void a(JsonBuilder.ObjectBuilder objectBuilder, HostedMethod hostedMethod) throws IOException {
        objectBuilder.append("id", (Object)hostedMethod.getWrapped().getId());
        objectBuilder.append("uniqueShortName", (Object)hostedMethod.getUniqueShortName());
    }

    private static void a(SourceMapping sourceMapping, JsonBuilder.ArrayBuilder arrayBuilder, Metadata.Builder builder) throws IOException {
        try (JsonBuilder.ObjectBuilder objectBuilder = arrayBuilder.nextEntry().object();){
            objectBuilder.append("start", (Object)sourceMapping.getStartOffset());
            objectBuilder.append("end", (Object)sourceMapping.getEndOffset());
            try (JsonBuilder.ArrayBuilder arrayBuilder2 = objectBuilder.append("positions").array();){
                for (NodeSourcePosition nodeSourcePosition = sourceMapping.getSourcePosition(); nodeSourcePosition != null; nodeSourcePosition = nodeSourcePosition.getCaller()) {
                    try (JsonBuilder.ObjectBuilder objectBuilder2 = arrayBuilder2.nextEntry().object();){
                        HostedMethod hostedMethod = (HostedMethod)nodeSourcePosition.getMethod();
                        a.a(hostedMethod, builder);
                        a.a(objectBuilder2, hostedMethod);
                        objectBuilder2.append("bci", (Object)nodeSourcePosition.getBCI());
                        continue;
                    }
                }
            }
        }
    }

    static class a {
        static final HostedOptionKey<String> PGOPerfSourceMappings = new HostedOptionKey<String>(null, a::j){

            public void update(EconomicMap<OptionKey<?>, Object> economicMap, Object object) {
                super.update(economicMap, object);
                if (object != null) {
                    SubstrateOptions.GenerateDebugInfo.update(economicMap, (Object)0);
                    SubstrateOptions.DeleteLocalSymbols.update(economicMap, (Object)false);
                    SubstrateOptions.PreserveFramePointer.update(economicMap, (Object)true);
                    GraalOptions.TrackNodeSourcePosition.update(economicMap, (Object)true);
                }
            }
        };

        a() {
        }

        private static void j(HostedOptionKey<String> hostedOptionKey) {
            if (hostedOptionKey.getValue() != null) {
                String string = "Cannot use " + PGOPerfSourceMappings.getName() + " if %s is set to %b.";
                UserError.guarantee(((Boolean)SubstrateOptions.DeleteLocalSymbols.getValue() == false ? 1 : 0) != 0, (String)string, (Object[])new Object[]{SubstrateOptions.DeleteLocalSymbols.getName(), true});
                UserError.guarantee((boolean)((Boolean)SubstrateOptions.PreserveFramePointer.getValue()), (String)string, (Object[])new Object[]{SubstrateOptions.PreserveFramePointer.getName(), false});
                UserError.guarantee((boolean)((Boolean)GraalOptions.TrackNodeSourcePosition.getValue(HostedOptionValues.singleton())), (String)string, (Object[])new Object[]{GraalOptions.TrackNodeSourcePosition.getName(), false});
                UserError.guarantee(((Integer)SubstrateOptions.GenerateDebugInfo.getValue() == 0 ? 1 : 0) != 0, (String)string, (Object[])new Object[]{SubstrateOptions.GenerateDebugInfo.getName(), false});
            }
        }
    }
}

