/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.profiling.features;

import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.code.IsolateEnterStub;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.hub.DynamicHubSupport;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.option.APIOption;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.core.bc;
import com.oracle.svm.enterprise.hosted.ml.features.provider.a;
import com.oracle.svm.enterprise.hosted.pgo.b;
import com.oracle.svm.enterprise.hosted.pgo.features.PGOFeature;
import com.oracle.svm.enterprise.hosted.phases.priorityinline.SubstratePriorityInliningPhase;
import com.oracle.svm.enterprise.profiling.metadata.codepositions.h;
import com.oracle.svm.enterprise.profiling.metadata.elements.c;
import com.oracle.svm.enterprise.profiling.metadata.elements.d;
import com.oracle.svm.enterprise.profiling.p;
import com.oracle.svm.enterprise.profiling.profiles.ProfilingRuntimeProfile;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.c.CGlobalDataFeature;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.util.LogUtils;
import com.oracle.svm.util.ReflectionUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.graal.compiler.loop.phases.LoopSafepointEliminationPhase;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class ProfilingFeature
implements InternalFeature {
    public static final SubstrateOptions.OptimizationLevel wR = SubstrateOptions.OptimizationLevel.O2;

    private static void h(HostedOptionKey<Boolean> hostedOptionKey) {
        if (!((Boolean)hostedOptionKey.getValue()).booleanValue()) {
            return;
        }
        PGOFeature.validateMutuallyExclusivePGOOptions();
        String string = SubstrateOptionsParser.commandArgument(hostedOptionKey, (String)"+");
        UserError.guarantee((SubstrateOptions.optimizationLevel() == wR ? 1 : 0) != 0, (String)"Optimization level cannot be changed via '%s' when '%s' is used. Native Image needs to control the optimization level for instrumented builds.", (Object[])new Object[]{SubstrateOptionsParser.commandArgument((OptionKey)SubstrateOptions.Optimize, (String)((String)SubstrateOptions.Optimize.getValue())), string});
        UserError.guarantee((boolean)((Boolean)GraalOptions.TrackNodeSourcePosition.getValue(HostedOptionValues.singleton())), (String)"'%s' cannot be disabled when '%s' is used.", (Object[])new Object[]{SubstrateOptionsParser.commandArgument((OptionKey)GraalOptions.TrackNodeSourcePosition, (String)"-"), string});
        UserError.guarantee(((Boolean)SubstrateOptions.AOTTrivialInline.getValue() == false ? 1 : 0) != 0, (String)"'%s' cannot be enabled when '%s' is used.", (Object[])new Object[]{SubstrateOptionsParser.commandArgument((OptionKey)SubstrateOptions.AOTTrivialInline, (String)"+"), string});
    }

    private static void i(HostedOptionKey<Boolean> hostedOptionKey) {
        if (!((Boolean)hostedOptionKey.getValue()).booleanValue()) {
            return;
        }
        UserError.guarantee((boolean)((Boolean)SubstrateOptions.AllowVMInternalThreads.getValue()), (String)"%s is disabled. Please enable it and rerun the build.", (Object[])new Object[]{SubstrateOptionsParser.commandArgument((OptionKey)SubstrateOptions.AllowVMInternalThreads, (String)"-")});
    }

    public static boolean hd() {
        boolean bl2 = a.SamplingCollect.hasBeenSet();
        return bl2 && (Boolean)a.SamplingCollect.getValue() != false || !bl2 && (Boolean)Options.ProfilingEnabled.getValue() != false;
    }

    public static boolean he() {
        if (Options.ProfilingEnableProfileDumpHooks.hasBeenSet()) {
            return (Boolean)Options.ProfilingEnableProfileDumpHooks.getValue();
        }
        return (Boolean)SubstrateOptions.SharedLibrary.getValue() == false;
    }

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return List.of(CGlobalDataFeature.class);
    }

    public void registerForeignCalls(SubstrateForeignCallsProvider substrateForeignCallsProvider) {
        p.registerForeignCalls(substrateForeignCallsProvider);
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess isInConfigurationAccess) {
        if (!((Boolean)Options.UseOldProfilingFramework.getValue()).booleanValue()) {
            return false;
        }
        return (Boolean)Options.ProfilingEnabled.getValue() != false || ProfilingFeature.hd();
    }

    public void registerLowerings(RuntimeConfiguration runtimeConfiguration, OptionValues optionValues, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> map, boolean bl2) {
        if (bl2) {
            p.b(optionValues, providers, map);
        }
    }

    public void afterRegistration(Feature.AfterRegistrationAccess afterRegistrationAccess) {
        ImageSingletons.add(ProfilingRuntimeProfile.class, (Object)new ProfilingRuntimeProfile());
        ImageSingletons.add(com.oracle.svm.enterprise.profiling.metadata.b.class, (Object)new com.oracle.svm.enterprise.profiling.metadata.b());
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess beforeAnalysisAccess) {
        RuntimeSupport runtimeSupport;
        ProfilingRuntimeProfile profilingRuntimeProfile = ProfilingRuntimeProfile.instance();
        com.oracle.svm.enterprise.profiling.metadata.b b2 = ProfilingRuntimeProfile.metadataBuilder();
        if (ProfilingFeature.he()) {
            runtimeSupport = RuntimeSupport.getRuntimeSupport();
            runtimeSupport.addStartupHook(profilingRuntimeProfile.dumpStartupHook());
            runtimeSupport.addShutdownHook(profilingRuntimeProfile.dumpShutdownHook());
        }
        b2.c(new d());
        b2.a(new c());
        runtimeSupport = (FeatureImpl.BeforeAnalysisAccessImpl)beforeAnalysisAccess;
        AnalysisMetaAccess analysisMetaAccess = runtimeSupport.getMetaAccess();
        Iterator iterator = Stream.of("hashCode", "toString", "wait", "notify").map(string -> ReflectionUtil.lookupMethod(Object.class, (String)string, (Class[])new Class[0])).map(arg_0 -> ((AnalysisMetaAccess)analysisMetaAccess).lookupJavaMethod(arg_0)).iterator();
        NodeSourcePosition nodeSourcePosition = new NodeSourcePosition(null, (ResolvedJavaMethod)iterator.next(), 0);
        b2.a(p.a(nodeSourcePosition, b2::g), (byte)0, 0);
        b2.a(p.a(new NodeSourcePosition(nodeSourcePosition, (ResolvedJavaMethod)iterator.next(), 0), (Integer n2, Integer n3) -> b2.a((int)n2, (int)n3, new int[]{0, 1}, new int[]{0, 1})), (byte)0, 0);
        b2.a(p.a(new NodeSourcePosition(nodeSourcePosition, (ResolvedJavaMethod)iterator.next(), 0), (Integer n2, Integer n3) -> b2.a((int)n2, (int)n3, new ResolvedJavaType[0])), (byte)0, 0);
        b2.a(p.a(new NodeSourcePosition(nodeSourcePosition, (ResolvedJavaMethod)iterator.next(), 0), (Integer n2, Integer n3) -> new h(0, 0)), (byte)0, 0);
        profilingRuntimeProfile.data().iG();
        profilingRuntimeProfile.setMetadata(b2.iS());
        for (SnippetRuntime.SubstrateForeignCallDescriptor substrateForeignCallDescriptor : p.yA) {
            runtimeSupport.registerAsRoot((AnalysisMethod)substrateForeignCallDescriptor.findMethod((MetaAccessProvider)analysisMetaAccess), true, "Profiling support, registered in " + String.valueOf(ProfilingFeature.class), new MultiMethod.MultiMethodKey[0]);
        }
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess afterAnalysisAccess) {
        ProfilingRuntimeProfile.instance().reset();
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess beforeCompilationAccess) {
        int n2 = ((DynamicHubSupport)ImageSingletons.lookup(DynamicHubSupport.class)).getMaxTypeId();
        VMError.guarantee((n2 > 0 ? 1 : 0) != 0, (String)"Max type ID should be positive.");
        int n3 = ProfilingRuntimeProfile.instance().data().W(n2);
        VMError.guarantee((n3 == 0 ? 1 : 0) != 0, (String)"The monitor record should be in the beginning of the data storage.");
        com.oracle.svm.enterprise.profiling.metadata.b b2 = ProfilingRuntimeProfile.metadataBuilder();
        if (((Boolean)Options.ProfilingEnabled.getValue()).booleanValue()) {
            b2.f(n2, n3);
        }
        if (Options.ProfilingPackagePrefixes.hasBeenSet()) {
            Set set = Arrays.stream(((String)Options.ProfilingPackagePrefixes.getValue()).split(",")).map(string -> string.split("\\.")).map(Arrays::asList).collect(Collectors.toSet());
            Set<String> set2 = ((FeatureImpl.BeforeCompilationAccessImpl)beforeCompilationAccess).getUniverse().getTypes().stream().filter(hostedType -> ProfilingFeature.a(hostedType, set)).map(JavaType::toClassName).collect(Collectors.toSet());
            set2.add(IsolateEnterStub.class.getName());
            b2.f(set2);
        }
    }

    public void afterCompilation(Feature.AfterCompilationAccess afterCompilationAccess) {
        com.oracle.svm.enterprise.profiling.metadata.b b2 = ProfilingRuntimeProfile.metadataBuilder();
        HostedUniverse hostedUniverse = ((FeatureImpl.AfterCompilationAccessImpl)afterCompilationAccess).getUniverse();
        Set<HostedMethod> set = ProfilingFeature.a(hostedUniverse, b2.iR());
        Set<HostedType> set2 = ProfilingFeature.a(hostedUniverse, b2, set);
        b2.b(ProfilingFeature.d(set));
        b2.a(ProfilingFeature.e(set2));
        ProfilingRuntimeProfile.instance().setMetadata(b2.iS());
    }

    private static boolean a(HostedType hostedType, Set<List<String>> set) {
        if (hostedType.isPrimitive() || hostedType.isArray() && hostedType.getBaseType().isPrimitive()) {
            return true;
        }
        List<String> list = ProfilingFeature.b(hostedType);
        return set.stream().anyMatch(list2 -> ProfilingFeature.b(list, list2));
    }

    private static List<String> b(HostedType hostedType) {
        String[] stringArray = hostedType.toJavaName().split("\\.");
        return Arrays.asList(Arrays.copyOf(stringArray, stringArray.length - 1));
    }

    private static boolean b(List<String> list, List<String> list2) {
        if (list2.size() > list.size()) {
            return false;
        }
        return list.subList(0, list2.size()).equals(list2);
    }

    private static Set<HostedMethod> a(HostedUniverse hostedUniverse, Set<String> set) {
        if (com.oracle.svm.enterprise.hosted.profiling.features.jfr.a.isSupported()) {
            return new HashSet<HostedMethod>(hostedUniverse.getMethods());
        }
        Map<Integer, HostedMethod> map = hostedUniverse.getMethods().stream().collect(Collectors.toMap(hostedMethod -> hostedMethod.getWrapped().getId(), hostedMethod -> hostedMethod));
        return set.stream().flatMap(string -> ProfilingFeature.a(string, map)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private static Stream<HostedMethod> a(String string2, Map<Integer, HostedMethod> map) {
        return Arrays.stream(p.U(string2)).map(string -> (HostedMethod)map.get(p.T(string).getLeft()));
    }

    private static com.oracle.svm.enterprise.profiling.metadata.elements.b<c> d(Set<HostedMethod> set) {
        return new com.oracle.svm.enterprise.profiling.metadata.elements.b<c>(set.stream().map(hostedMethod -> {
            HostedType hostedType = hostedMethod.getDeclaringClass();
            int[] nArray = hostedMethod.getSignature().toParameterList(null).stream().mapToInt(p::j).toArray();
            int n2 = p.j(hostedMethod.getSignature().getReturnType());
            return new c(p.g((ResolvedJavaMethod)hostedMethod), hostedMethod.getName(), p.j((ResolvedJavaType)hostedType), n2, nArray);
        }).collect(Collectors.toList()));
    }

    private static Set<HostedType> a(HostedUniverse hostedUniverse, com.oracle.svm.enterprise.profiling.metadata.b b2, Set<HostedMethod> set) {
        Set<HostedType> set2 = hostedUniverse.getTypes().stream().filter(hostedType -> b.c(hostedType.getWrapped())).filter(hostedType -> b2.X(hostedType.toClassName())).collect(Collectors.toSet());
        Set set3 = set.stream().flatMap(ProfilingFeature::y).collect(Collectors.toSet());
        ProfilingFeature.a(set, b2);
        set2.addAll(set3);
        return set2;
    }

    private static void a(Set<HostedMethod> set2, com.oracle.svm.enterprise.profiling.metadata.b b2) {
        HashMap<HostedMethod, Set<String>> hashMap = new HashMap<HostedMethod, Set<String>>();
        HashSet<String> hashSet = new HashSet<String>();
        ProfilingFeature.a(set2, b2, hashMap, hashSet);
        if (!hashMap.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder("Incomplete partial profiling. We profile forbidden types (types that do not match the profiling package prefixes):").append(System.lineSeparator());
            hashMap.forEach((hostedMethod, set) -> stringBuilder.append(hostedMethod.format("%H.%n")).append(" -> ").append(String.join((CharSequence)", ", set)).append(System.lineSeparator()));
            stringBuilder.append("Consider expanding your filter by including the packages:").append(System.lineSeparator()).append("-H:ProfilingPackagePrefixes=").append(String.join((CharSequence)",", hashSet));
            LogUtils.warning((String)stringBuilder.toString());
        }
    }

    private static void a(Set<HostedMethod> set, com.oracle.svm.enterprise.profiling.metadata.b b2, Map<HostedMethod, Set<String>> map, Set<String> set2) {
        for (HostedMethod hostedMethod : set) {
            Set<HostedType> set3 = ProfilingFeature.y(hostedMethod).filter(hostedType -> !b2.X(hostedType.toClassName())).collect(Collectors.toSet());
            ProfilingFeature.a(hostedMethod, set3, map, set2);
        }
    }

    private static void a(HostedMethod hostedMethod, Set<HostedType> set, Map<HostedMethod, Set<String>> map, Set<String> set2) {
        for (HostedType hostedType : set) {
            String string;
            map.putIfAbsent(hostedMethod, new HashSet());
            map.get(hostedMethod).add(hostedType.toClassName());
            String string2 = string = hostedType.isArray() ? hostedType.getBaseType().toClassName() : hostedType.toClassName();
            if (string.contains(".")) {
                string = string.substring(0, string.lastIndexOf("."));
            }
            set2.add(string);
        }
    }

    private static Stream<HostedType> y(HostedMethod hostedMethod) {
        return Stream.concat(Stream.of(hostedMethod.getDeclaringClass(), (HostedType)hostedMethod.getSignature().getReturnType()), hostedMethod.getSignature().toParameterList(null).stream());
    }

    private static com.oracle.svm.enterprise.profiling.metadata.elements.b<d> e(Set<HostedType> set) {
        return new com.oracle.svm.enterprise.profiling.metadata.elements.b<d>(set.stream().map(hostedType -> new d(p.j((ResolvedJavaType)hostedType), hostedType.toClassName())).collect(Collectors.toList()));
    }

    public static class a {
        @APIOption(name={"pgo-sampling"})
        public static final HostedOptionKey<Boolean> SamplingCollect = new HostedOptionKey<Boolean>(null, ProfilingFeature::i){

            protected void a(EconomicMap<OptionKey<?>, Object> economicMap, Boolean bl2, Boolean bl3) {
                if (bl3.booleanValue()) {
                    LoopSafepointEliminationPhase.Options.RemoveLoopSafepoints.update(economicMap, (Object)false);
                }
            }

            protected /* synthetic */ void onValueUpdate(EconomicMap economicMap, Object object, Object object2) {
                this.a(economicMap, (Boolean)object, (Boolean)object2);
            }
        };
    }

    public static class Options {
        @APIOption(name={"pgo-instrument"})
        public static final HostedOptionKey<Boolean> ProfilingEnabled = new HostedOptionKey<Boolean>(Boolean.valueOf(false), ProfilingFeature::h){

            protected void a(EconomicMap<OptionKey<?>, Object> economicMap, Boolean bl2, Boolean bl3) {
                if (bl3.booleanValue()) {
                    Object object = economicMap.get((Object)SubstrateOptions.Optimize);
                    if (object != null) {
                        if (!object.equals("2")) {
                            SubstrateOptions.Optimize.update(economicMap, (Object)wR.getOptionSwitch());
                        }
                        GraalOptions.TrackNodeSourcePosition.update(economicMap, GraalOptions.TrackNodeSourcePosition.getDefaultValue());
                        SubstrateOptions.IncludeNodeSourcePositions.update(economicMap, SubstrateOptions.IncludeNodeSourcePositions.getDefaultValue());
                        SubstrateOptions.SourceLevelDebug.update(economicMap, SubstrateOptions.SourceLevelDebug.getDefaultValue());
                        SubstrateOptions.AOTTrivialInline.update(economicMap, SubstrateOptions.AOTTrivialInline.getDefaultValue());
                    }
                    GraalOptions.TrackNodeSourcePosition.update(economicMap, (Object)true);
                    SubstrateOptions.AOTTrivialInline.update(economicMap, (Object)false);
                    bc.AOTPriorityInline.update(economicMap, (Object)true);
                    LoopSafepointEliminationPhase.Options.RemoveLoopSafepoints.update(economicMap, (Object)false);
                    SubstratePriorityInliningPhase.a.UseIPEA.update(economicMap, (Object)false);
                    a.b.MLProfileInference.update(economicMap, (Object)false);
                }
            }

            protected /* synthetic */ void onValueUpdate(EconomicMap economicMap, Object object, Object object2) {
                this.a(economicMap, (Boolean)object, (Boolean)object2);
            }
        };
        public static final HostedOptionKey<Boolean> UseOldProfilingFramework = new HostedOptionKey((Object)false, hostedOptionKey -> {
            boolean bl2;
            Boolean bl3 = (Boolean)ProfilingEnabled.getValue();
            Boolean bl4 = (Boolean)a.SamplingCollect.getValue();
            boolean bl5 = bl2 = !(bl3 != null && bl3 != false || bl4 != null && bl4 != false);
            if (hostedOptionKey.hasBeenSet() && !PGOFeature.isPGOEnabled() && bl2) {
                UserError.abort((String)"Cannot use %s without enabling pgo, profiling or sampling.", (Object[])new Object[]{hostedOptionKey.getName()});
            }
        });
        static final HostedOptionKey<Boolean> ProfilingEnableProfileDumpHooks = new HostedOptionKey((Object)true);
        public static final HostedOptionKey<String> ProfilingPackagePrefixes = new HostedOptionKey(null);
    }
}

