/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.pgo.profiles;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.enterprise.hosted.pgo.profiles.PGOProfilesLookup;
import com.oracle.svm.enterprise.profiling.framework.CommonInstrumentationData;
import com.oracle.svm.enterprise.profiling.framework.PGOData;
import com.oracle.svm.enterprise.profiling.framework.collection.CallingContext;
import com.oracle.svm.enterprise.profiling.framework.collection.CallingContextForest;
import com.oracle.svm.enterprise.profiling.framework.collection.CodePosition;
import com.oracle.svm.enterprise.profiling.metadata.codepositions.ProfilingHostedCodePosition;
import com.oracle.svm.hosted.meta.HostedMethod;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.UnresolvedJavaType;

public class a
implements PGOProfilesLookup {
    private PGOData tW;
    private c tX;

    public a(PGOData pGOData, c c2) {
        this.tW = pGOData;
        this.tX = c2;
    }

    @Override
    public Optional<PGOProfilesLookup.ProfiledValue<Long>> getCallCountProfile(HostedMethod hostedMethod) {
        if (this.tW == null) {
            return Optional.empty();
        }
        CallingContextForest.BestFit bestFit = this.tW.metadata().forest().findBestFit(a.u(hostedMethod));
        if (bestFit == null) {
            return Optional.empty();
        }
        e e2 = new e();
        bestFit.cursor().forEachPayloadWithCallers(e2);
        if (e2.rr == 0L) {
            return Optional.empty();
        }
        return Optional.of(new PGOProfilesLookup.ProfiledValue<Long>(this.tW.source(), e2.rr));
    }

    private static CallingContext u(HostedMethod hostedMethod) {
        return CallingContext.withCallee(new CodePosition(hostedMethod.wrapped.getId(), 0), CallingContext.empty());
    }

    @Override
    public Optional<Map<AnalysisType, Long>> getVirtualInvokeProfile(List<ProfilingHostedCodePosition> list) {
        if (this.tW == null) {
            return Optional.empty();
        }
        CallingContext callingContext = a.l(list);
        CallingContextForest.BestFit bestFit = this.tW.metadata().forest().findBestFit(callingContext);
        if (bestFit == null) {
            return Optional.empty();
        }
        g g2 = new g();
        a.a(bestFit, g2);
        return g2.uh.isEmpty() ? Optional.empty() : Optional.of(g2.uh);
    }

    @Override
    public Optional<Map<JavaType, Long>> getInstanceofProfile(List<ProfilingHostedCodePosition> list) {
        if (this.tW == null) {
            return Optional.empty();
        }
        CallingContext callingContext = a.l(list);
        CallingContextForest.BestFit bestFit = this.tW.metadata().forest().findBestFit(callingContext);
        if (bestFit == null) {
            return Optional.empty();
        }
        d d2 = new d();
        a.a(bestFit, d2);
        return d2.ue.isEmpty() ? Optional.empty() : Optional.of(d2.ue);
    }

    private static CallingContext l(List<ProfilingHostedCodePosition> list) {
        ArrayList<CodePosition> arrayList = new ArrayList<CodePosition>();
        for (ProfilingHostedCodePosition profilingHostedCodePosition : list) {
            arrayList.add(new CodePosition(profilingHostedCodePosition.getMethod().getId(), profilingHostedCodePosition.getBCI()));
        }
        return CallingContext.create(arrayList);
    }

    private static void a(CallingContextForest.BestFit bestFit, f f2) {
        bestFit.cursor().forEachPayload(f2);
        if (!f2.isEmpty()) {
            return;
        }
        if (bestFit.fullyMatchedCallingContext()) {
            bestFit.cursor().forEachPayloadWithCallers(f2);
            return;
        }
        for (CallingContextForest.Cursor cursor : bestFit.calleeContext().reversed()) {
            cursor.forEachPayload(f2);
            if (f2.isEmpty()) continue;
            return;
        }
    }

    @Override
    public Optional<PGOProfilesLookup.ProfiledValue<long[]>> getConditionalProfile(List<ProfilingHostedCodePosition> list) {
        if (this.tW == null) {
            return Optional.empty();
        }
        CallingContextForest.BestFit bestFit = this.tW.metadata().forest().findBestFit(a.l(list));
        if (bestFit == null) {
            return Optional.empty();
        }
        b b2 = new b();
        a.a(bestFit, b2);
        return b2.ua == null ? Optional.empty() : Optional.of(new PGOProfilesLookup.ProfiledValue<long[]>(this.tW.source(), b2.ua));
    }

    @Override
    public Optional<Map<AnalysisType, Long>> getMonitorProfiles() {
        if (this.tW == null) {
            return Optional.empty();
        }
        HashMap hashMap = new HashMap();
        this.tW.metadata().forEachMonitorTypeID(n2 -> {
            AnalysisType analysisType = this.tX.uc.get(n2);
            long l2 = this.tW.commonInstrumentationData().readTotalMonitorCount(n2);
            hashMap.put(analysisType, l2);
        });
        return hashMap.isEmpty() ? Optional.empty() : Optional.of(hashMap);
    }

    @Override
    public Optional<Map<List<ProfilingHostedCodePosition>, Long>> getSampleCounts() {
        if (this.tW == null) {
            return Optional.empty();
        }
        return Optional.of(this.gk());
    }

    private Map<List<ProfilingHostedCodePosition>, Long> gk() {
        HashMap<List<ProfilingHostedCodePosition>, Long> hashMap = new HashMap<List<ProfilingHostedCodePosition>, Long>();
        this.tW.samplingData().samples().topDown((callingContext, l2) -> {
            if (l2 > 0L) {
                List<ProfilingHostedCodePosition> list = this.a((CallingContext)callingContext);
                hashMap.put(list, (Long)l2);
            }
        });
        return hashMap;
    }

    private List<ProfilingHostedCodePosition> a(CallingContext callingContext) {
        ArrayList<ProfilingHostedCodePosition> arrayList = new ArrayList<ProfilingHostedCodePosition>();
        callingContext.traverseFromCallee(codePosition -> arrayList.add(new ProfilingHostedCodePosition(this.tX.ud.get(codePosition.methodID()), codePosition.bci())));
        return arrayList;
    }

    @Override
    public void clear() {
        this.tW = null;
        this.tX = null;
    }

    @Override
    public Optional<long[]> getSample(com.oracle.svm.enterprise.profiling.metadata.cctree.c c2) {
        return Optional.empty();
    }

    @Override
    public Optional<Map<List<ProfilingHostedCodePosition>, com.oracle.svm.enterprise.profiling.metadata.cctree.c>> getSamples() {
        return Optional.empty();
    }

    private static long b(long l2, long l3) {
        assert (l2 >= 0L && l3 >= 0L) : "Negative counter value";
        long l4 = Math.max(0L, l2) + Math.max(0L, l3);
        return l4 >= 0L ? l4 : Long.MAX_VALUE;
    }

    public static final class c
    extends Record {
        private final Map<Integer, AnalysisType> uc;
        private final Map<Integer, AnalysisMethod> ud;
        private final Map<Integer, UnresolvedJavaType> unresolvedJavaTypeMap;

        public c() {
            this(new HashMap<Integer, AnalysisType>(), new HashMap<Integer, AnalysisMethod>(), new HashMap<Integer, UnresolvedJavaType>());
        }

        public c(Map<Integer, AnalysisType> map, Map<Integer, AnalysisMethod> map2, Map<Integer, UnresolvedJavaType> map3) {
            this.uc = map;
            this.ud = map2;
            this.unresolvedJavaTypeMap = map3;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "globalIDToAnalysisType;globalIDToAnalysisMethod;unresolvedJavaTypeMap", "uc", "ud", "unresolvedJavaTypeMap"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "globalIDToAnalysisType;globalIDToAnalysisMethod;unresolvedJavaTypeMap", "uc", "ud", "unresolvedJavaTypeMap"}, this);
        }

        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "globalIDToAnalysisType;globalIDToAnalysisMethod;unresolvedJavaTypeMap", "uc", "ud", "unresolvedJavaTypeMap"}, this, object);
        }

        public Map<Integer, AnalysisType> gm() {
            return this.uc;
        }

        public Map<Integer, AnalysisMethod> go() {
            return this.ud;
        }

        public Map<Integer, UnresolvedJavaType> gp() {
            return this.unresolvedJavaTypeMap;
        }
    }

    private final class e
    implements CallingContextForest.PayloadConsumer {
        long rr;

        private e() {
        }

        @Override
        public void accept(CallingContextForest.Payload payload) {
            if (payload instanceof CommonInstrumentationData.MethodEntryPayload) {
                CommonInstrumentationData.MethodEntryPayload methodEntryPayload = (CommonInstrumentationData.MethodEntryPayload)payload;
                this.rr += methodEntryPayload.readTotalCounterValue(a.this.tW.commonInstrumentationData().storage());
            }
        }
    }

    private final class g
    extends f {
        Map<AnalysisType, Long> uh;

        private g() {
            super(a.this);
            this.uh = new HashMap<AnalysisType, Long>();
        }

        @Override
        public void accept(CallingContextForest.Payload payload) {
            if (payload instanceof CommonInstrumentationData.VirtualCallPayload) {
                CommonInstrumentationData.VirtualCallPayload virtualCallPayload = (CommonInstrumentationData.VirtualCallPayload)payload;
                for (int i2 = 0; i2 < virtualCallPayload.length(); ++i2) {
                    int n2 = virtualCallPayload.typeID(a.this.tW.commonInstrumentationData().storage(), i2);
                    long l2 = virtualCallPayload.readTotalCounterValue(a.this.tW.commonInstrumentationData().storage(), i2);
                    AnalysisType analysisType = a.this.tX.uc.get(n2);
                    if (analysisType == null || l2 <= 0L) {
                        assert (l2 == 0L) : "Negative value in virtual call counter: " + l2;
                        continue;
                    }
                    this.uh.merge(analysisType, l2, a::b);
                }
            }
        }

        @Override
        boolean isEmpty() {
            return this.uh.isEmpty();
        }
    }

    private abstract class f
    implements CallingContextForest.PayloadConsumer {
        private f(a a2) {
        }

        abstract boolean isEmpty();
    }

    private final class d
    extends f {
        Map<JavaType, Long> ue;

        private d() {
            super(a.this);
            this.ue = new HashMap<JavaType, Long>();
        }

        @Override
        public void accept(CallingContextForest.Payload payload) {
            if (payload instanceof CommonInstrumentationData.InstanceOfPayload) {
                CommonInstrumentationData.InstanceOfPayload instanceOfPayload = (CommonInstrumentationData.InstanceOfPayload)payload;
                for (int i2 = 0; i2 < instanceOfPayload.length(); ++i2) {
                    int n2 = instanceOfPayload.typeID(a.this.tW.commonInstrumentationData().storage(), i2);
                    long l2 = instanceOfPayload.readTotalCounterValue(a.this.tW.commonInstrumentationData().storage(), i2);
                    assert (l2 >= 0L) : "Negative value in virtual call counter: " + l2;
                    AnalysisType analysisType = a.this.tX.uc.get(n2);
                    if (analysisType == null) {
                        UnresolvedJavaType unresolvedJavaType = a.this.tX.unresolvedJavaTypeMap.get(n2);
                        if (unresolvedJavaType == null) continue;
                        this.ue.merge((JavaType)unresolvedJavaType, l2, a::b);
                        continue;
                    }
                    this.ue.merge((JavaType)analysisType, l2, a::b);
                }
            }
        }

        @Override
        boolean isEmpty() {
            return this.ue.isEmpty();
        }
    }

    private final class b
    extends f {
        long[] ua;

        private b() {
            super(a.this);
        }

        @Override
        public void accept(CallingContextForest.Payload payload) {
            if (payload instanceof CommonInstrumentationData.ConditionalPayload) {
                int n2;
                CommonInstrumentationData.ConditionalPayload conditionalPayload = (CommonInstrumentationData.ConditionalPayload)payload;
                if (this.ua == null) {
                    this.ua = new long[conditionalPayload.length() * 3];
                    for (n2 = 0; n2 < conditionalPayload.length(); ++n2) {
                        this.ua[3 * n2] = conditionalPayload.bciAt(n2);
                        this.ua[3 * n2 + 1] = conditionalPayload.successorAt(n2);
                    }
                }
                if (3 * conditionalPayload.length() != this.ua.length) {
                    return;
                }
                for (n2 = 0; n2 < conditionalPayload.length(); ++n2) {
                    long l2 = conditionalPayload.readTotalCounterValue(a.this.tW.commonInstrumentationData().storage(), n2);
                    if (l2 <= 0L) {
                        assert (l2 == 0L) : "Negative value in conditional counter: " + l2;
                        continue;
                    }
                    this.ua[3 * n2 + 2] = a.b(this.ua[3 * n2 + 2], l2);
                }
            }
        }

        @Override
        boolean isEmpty() {
            return this.ua == null;
        }
    }

    public static final class a
    implements PGOProfilesLookup {
        private final PGOProfilesLookup tY;
        private final PGOProfilesLookup tZ;

        private static void a(String string, Object object, Object object2, Object object3) {
            if (!Objects.equals(object2, object3)) {
                System.out.printf("[PGO] %s profile diff! legacy: %s, replacement: %s, context: %s.%n", string, object2, object3, object);
            }
        }

        public a(PGOProfilesLookup pGOProfilesLookup, a a2) {
            this.tY = pGOProfilesLookup;
            this.tZ = a2;
        }

        @Override
        public Optional<PGOProfilesLookup.ProfiledValue<Long>> getCallCountProfile(HostedMethod hostedMethod) {
            Optional<PGOProfilesLookup.ProfiledValue<Long>> optional = this.tZ.getCallCountProfile(hostedMethod);
            a.a("call-count", hostedMethod.format("%H.%n"), this.tY.getCallCountProfile(hostedMethod), optional);
            return optional;
        }

        @Override
        public Optional<Map<AnalysisType, Long>> getVirtualInvokeProfile(List<ProfilingHostedCodePosition> list) {
            Optional<Map<AnalysisType, Long>> optional = this.tZ.getVirtualInvokeProfile(list);
            a.a("virtual-call", list, this.tY.getVirtualInvokeProfile(list), optional);
            return optional;
        }

        @Override
        public Optional<PGOProfilesLookup.ProfiledValue<long[]>> getConditionalProfile(List<ProfilingHostedCodePosition> list) {
            Optional<PGOProfilesLookup.ProfiledValue<long[]>> optional = this.tZ.getConditionalProfile(list);
            a.a("conditional", list, a.a(this.tY.getConditionalProfile(list)), a.a(optional));
            return optional;
        }

        private static Object a(Optional<PGOProfilesLookup.ProfiledValue<long[]>> optional) {
            if (optional.isPresent()) {
                PGOProfilesLookup.ProfiledValue<long[]> profiledValue = optional.get();
                return "[" + String.valueOf(profiledValue.source()) + " " + Arrays.toString(profiledValue.value()) + "]";
            }
            return optional.toString();
        }

        @Override
        public Optional<Map<AnalysisType, Long>> getMonitorProfiles() {
            Optional<Map<AnalysisType, Long>> optional = this.tZ.getMonitorProfiles();
            a.a("monitor", "", this.tY.getMonitorProfiles(), optional);
            return optional;
        }

        @Override
        public Optional<long[]> getSample(com.oracle.svm.enterprise.profiling.metadata.cctree.c c2) {
            return Optional.empty();
        }

        @Override
        public Optional<Map<List<ProfilingHostedCodePosition>, com.oracle.svm.enterprise.profiling.metadata.cctree.c>> getSamples() {
            return Optional.empty();
        }

        @Override
        public Optional<Map<List<ProfilingHostedCodePosition>, Long>> getSampleCounts() {
            return this.tZ.getSampleCounts();
        }
    }
}

