/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.ml.features;

import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.hosted.ml.features.PathFeatures;
import com.oracle.svm.enterprise.hosted.ml.features.a;
import com.oracle.svm.enterprise.hosted.ml.features.b;
import com.oracle.svm.enterprise.hosted.ml.features.c;
import com.oracle.svm.enterprise.hosted.ml.features.e;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.ControlSplitNode;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;

public class ControlSplitFeatures
extends com.oracle.graal.compiler.enterprise.ml.features.c
implements a {
    private final ResolvedJavaMethod originMethod;
    private final ControlSplitNode node;
    private final ControlSplitNode parent;
    private final HIRBlock block;
    @com.oracle.graal.compiler.enterprise.ml.features.b(n=1)
    private final b csType;
    @com.oracle.graal.compiler.enterprise.ml.features.b(n=2)
    private final b csConditionType;
    @com.oracle.graal.compiler.enterprise.ml.features.b(n=3)
    private final e csDepth;
    @com.oracle.graal.compiler.enterprise.ml.features.b(n=4)
    private final e loopDepth;
    @com.oracle.graal.compiler.enterprise.ml.features.b(n=5)
    private final e dominatorDepth;
    @com.oracle.graal.compiler.enterprise.ml.features.b(n=6)
    private e blockEstimatedAssemblySize;
    @com.oracle.graal.compiler.enterprise.ml.features.b(n=7)
    private e blockEstimatedCPUCycles;
    @com.oracle.graal.compiler.enterprise.ml.features.b(n=8)
    private e blockEstimatedCPUCheap;
    @com.oracle.graal.compiler.enterprise.ml.features.b(n=9)
    private e blockEstimatedCPUExpensive;
    @com.oracle.graal.compiler.enterprise.ml.features.b(n=10)
    private final c blockDataFlowHistogram;
    @com.oracle.graal.compiler.enterprise.ml.features.b(n=11)
    private final e predecessorsCount;
    @com.oracle.graal.compiler.enterprise.ml.features.b(n=12)
    private final c predecessorsDataFlowHistogram;
    private final EconomicMap<AbstractBeginNode, PathFeatures> branches;
    private final List<Integer> branchesOrder;
    private EconomicMap<Integer, Double> label;
    private EconomicMap<Integer, Long> labelCount;
    private static final List<Field> orderedFeatures = ControlSplitFeatures.a(ControlSplitFeatures.class);
    private static final List<Field> orderedEncoderFeatures = ControlSplitFeatures.b(ControlSplitFeatures.class, List.of(b.class, c.class));
    private static final String featureName = ControlSplitFeatures.class.getSimpleName();
    private static final String subfeatureName = "branches";
    private static final String subfeatureOrder = "branchesOrder";

    public ControlSplitFeatures(ResolvedJavaMethod resolvedJavaMethod, ControlSplitNode controlSplitNode, ControlSplitNode controlSplitNode2, Class<? extends ControlSplitNode> clazz, Class<? extends LogicNode> clazz2, int n2, int n3, int n4, HIRBlock hIRBlock, int n5, int n6, int n7, int n8, EconomicMap<Class<? extends Node>, Integer> economicMap, int n9, EconomicMap<Class<? extends Node>, Integer> economicMap2) {
        this.originMethod = resolvedJavaMethod;
        this.node = controlSplitNode;
        this.parent = controlSplitNode2;
        this.csType = new b(clazz);
        this.csConditionType = new b(clazz2);
        this.csDepth = new e(n2);
        this.loopDepth = new e(n3);
        this.dominatorDepth = new e(n4);
        this.block = hIRBlock;
        this.blockEstimatedAssemblySize = new e(n5);
        this.blockEstimatedCPUCycles = new e(n6);
        this.blockEstimatedCPUCheap = new e(n7);
        this.blockEstimatedCPUExpensive = new e(n8);
        this.blockDataFlowHistogram = new c(economicMap);
        this.predecessorsCount = new e(n9);
        this.predecessorsDataFlowHistogram = new c(economicMap2);
        this.branches = EconomicMap.create((Equivalence)Equivalence.DEFAULT);
        this.branchesOrder = new ArrayList<Integer>();
        this.label = null;
        this.labelCount = null;
        if (this.node.getNodeSourcePosition() != null) {
            ControlSplitNode controlSplitNode3 = this.node;
            if (controlSplitNode3 instanceof IfNode) {
                IfNode ifNode = (IfNode)controlSplitNode3;
                this.branchesOrder.add(ControlSplitFeatures.getNodeSourcePosition((Node)ifNode.trueSuccessor()));
                this.branchesOrder.add(ControlSplitFeatures.getNodeSourcePosition((Node)ifNode.falseSuccessor()));
            } else {
                for (Node node : this.node.successors()) {
                    this.branchesOrder.add(ControlSplitFeatures.getNodeSourcePosition(node));
                }
            }
        }
    }

    public void addBranch(AbstractBeginNode abstractBeginNode, List<HIRBlock> list, Class<? extends Node> clazz, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, List<ResolvedJavaMethod> list2, EconomicMap<Class<? extends Node>, Integer> economicMap) {
        PathFeatures pathFeatures = new PathFeatures(list, clazz, n2, n3, n4, n5, n6, n7, n8, n9, list2, economicMap);
        this.branches.put((Object)abstractBeginNode, (Object)pathFeatures);
    }

    public boolean o() {
        return this.label != null && this.labelCount != null && this.label.size() > 0 && this.labelCount.size() > 0;
    }

    public List<Integer> a(EconomicMap<String, List<String>> economicMap) {
        List list = super.a(orderedFeatures, economicMap);
        if (this.node instanceof IfNode) {
            AbstractBeginNode abstractBeginNode = ((IfNode)this.node).trueSuccessor();
            assert (this.branches.containsKey((Object)abstractBeginNode));
            list.addAll(((PathFeatures)((Object)this.branches.get((Object)abstractBeginNode))).a(economicMap));
            AbstractBeginNode abstractBeginNode2 = ((IfNode)this.node).falseSuccessor();
            assert (this.branches.containsKey((Object)abstractBeginNode2));
            list.addAll(((PathFeatures)((Object)this.branches.get((Object)abstractBeginNode2))).a(economicMap));
        } else {
            GraalError.shouldNotReachHere((String)("Providing features for the currently unsupported control split: " + this.node.getNodeClass().toString()));
        }
        return list;
    }

    public void a(com.oracle.graal.compiler.enterprise.ml.features.serialization.a a2) {
        this.a(ControlSplitFeatures.class, a2);
    }

    protected List<Field> p() {
        return ControlSplitFeatures.a(ControlSplitFeatures.class, List.of(subfeatureName, subfeatureOrder, "label", "labelCount", "orderedFeatures", "orderedEncoderFeatures", "featureName", "subfeatureName", "subfeatureOrder"));
    }

    @Override
    public void setLabel(EconomicMap<Integer, Double> economicMap, EconomicMap<Integer, Long> economicMap2) {
        this.label = economicMap;
        this.labelCount = economicMap2;
    }

    public int getCsDepth() {
        return this.csDepth.getValue();
    }

    public ControlSplitNode getParent() {
        return this.parent;
    }

    public ControlSplitNode getNode() {
        return this.node;
    }

    public HIRBlock getBlock() {
        return this.block;
    }

    public Class<? extends Node> getCsType() {
        return this.csType.fx();
    }

    public Class<? extends Node> getCsConditionType() {
        return this.csConditionType.fx();
    }

    public int getLoopDepth() {
        return this.loopDepth.getValue();
    }

    public int getDominatorDepth() {
        return this.dominatorDepth.getValue();
    }

    public int getPredecessorsCount() {
        return this.predecessorsCount.getValue();
    }

    public PathFeatures getBranch(AbstractBeginNode abstractBeginNode) {
        if (!this.branches.containsKey((Object)abstractBeginNode)) {
            VMError.shouldNotReachHere((String)("Can not fetch branch features: invalid branch begin node specified " + String.valueOf(abstractBeginNode)));
        }
        return (PathFeatures)((Object)this.branches.get((Object)abstractBeginNode));
    }

    public int getBlockEstimatedAssemblySize() {
        return this.blockEstimatedAssemblySize.getValue();
    }

    public int getBlockEstimatedCPUCycles() {
        return this.blockEstimatedCPUCycles.getValue();
    }

    public int getBlockEstimatedCPUCheap() {
        return this.blockEstimatedCPUCheap.getValue();
    }

    public int getBlockEstimatedCPUExpensive() {
        return this.blockEstimatedCPUExpensive.getValue();
    }

    public EconomicMap<Class<? extends Node>, Integer> getBlockDataFlowHistogram() {
        return this.blockDataFlowHistogram.fy();
    }

    public EconomicMap<Class<? extends Node>, Integer> getPredecessorsDataFlowHistogram() {
        return this.predecessorsDataFlowHistogram.fy();
    }

    private static int getNodeSourcePosition(Node node) {
        NodeSourcePosition nodeSourcePosition = node.getNodeSourcePosition();
        return nodeSourcePosition != null ? nodeSourcePosition.getBCI() : -1;
    }

    @Override
    public long getLabelCount() {
        long l2 = 0L;
        Iterator iterator = this.labelCount.getValues().iterator();
        while (iterator.hasNext()) {
            long l3 = (Long)iterator.next();
            l2 += l3;
        }
        return l2;
    }
}

