/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.code.layout;

import com.oracle.svm.enterprise.hosted.code.layout.a;
import com.oracle.svm.hosted.meta.HostedMethod;
import java.util.Optional;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.phases.BasePhase;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;

public class CalculateCallEdgeInfoPhase
extends BasePhase<CoreProviders> {
    final a rC;

    public CalculateCallEdgeInfoPhase(a a2) {
        this.rC = a2;
    }

    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return BasePhase.NotApplicable.unlessRunAfter((BasePhase)this, (GraphState.StageFlag)GraphState.StageFlag.FINAL_PARTIAL_ESCAPE, (GraphState)graphState);
    }

    protected void run(StructuredGraph structuredGraph, CoreProviders coreProviders) {
        HostedMethod hostedMethod = (HostedMethod)structuredGraph.method();
        assert (this.rC.i(hostedMethod)) : "CalculateCallEdgeInfoPhase: Caller-callee count should not be overwritten: double entry for " + String.valueOf(hostedMethod);
        EconomicMap economicMap = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
        for (Node node : structuredGraph.getNodes()) {
            HostedMethod hostedMethod2 = CalculateCallEdgeInfoPhase.f(node);
            if (hostedMethod2 == null || hostedMethod2.equals(hostedMethod)) continue;
            economicMap.put((Object)hostedMethod2, (Object)1L);
        }
        this.rC.a(hostedMethod, (EconomicMap<HostedMethod, Long>)economicMap);
    }

    private static HostedMethod f(Node node) {
        if (node instanceof Invoke && ((Invoke)node).getInvokeKind().isDirect()) {
            return (HostedMethod)((Invoke)node).getTargetMethod();
        }
        return null;
    }
}

