/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.pki.x509;

import com.oracle.jipher.pki.x509.GeneralName;
import com.oracle.jipher.pki.x509.X509ExtnValue;
import com.oracle.jipher.tools.asn1.Asn1;
import com.oracle.jipher.tools.asn1.Asn1BerValue;
import com.oracle.jipher.tools.asn1.Asn1Exception;
import com.oracle.jipher.tools.asn1.UniversalTag;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AuthInfoAccess
implements X509ExtnValue {
    private static final String OID_OCSP = "1.3.6.1.5.5.7.48.1";
    private static final String OID_CA_ISSUERS = "1.3.6.1.5.5.7.48.2";
    private Map<String, List<GeneralName>> accessDescriptionMap;
    private byte[] encoding;

    private AuthInfoAccess(byte[] der, Map<String, List<GeneralName>> ads) {
        this.accessDescriptionMap = ads;
        this.encoding = der;
    }

    @Override
    public byte[] getEncoded() {
        return (byte[])this.encoding.clone();
    }

    public List<GeneralName> getLocations(String accessMethodOid) {
        return this.accessDescriptionMap.get(accessMethodOid);
    }

    public List<GeneralName> getOcsp() {
        return Collections.unmodifiableList(this.getLocations(OID_OCSP));
    }

    public List<GeneralName> getCaIssuers() {
        return Collections.unmodifiableList(this.getLocations(OID_CA_ISSUERS));
    }

    public List<String> getMethodOids() {
        return new ArrayList<String>(this.accessDescriptionMap.keySet());
    }

    public static AuthInfoAccess decode(X509Extension x509Object) {
        byte[] extBytes = x509Object.getExtensionValue("1.3.6.1.5.5.7.1.1");
        if (extBytes == null) {
            return null;
        }
        LinkedHashMap<String, List<GeneralName>> accessDescriptions = new LinkedHashMap<String, List<GeneralName>>();
        try {
            byte[] extVal = Asn1.decodeOne(extBytes).tag(UniversalTag.OCTET_STRING).getOctetString();
            List<Asn1BerValue> aias = Asn1.decodeOne(extVal).tag(UniversalTag.SEQUENCE).sequence();
            for (Asn1BerValue aia : aias) {
                List<Asn1BerValue> oidAndName = aia.count(2).sequence();
                String oid = oidAndName.get(0).getOid();
                byte[] generalName = oidAndName.get(1).encodeDerOctets();
                GeneralName gn = GeneralName.decode(generalName);
                accessDescriptions.computeIfAbsent(oid, k -> new ArrayList()).add(gn);
            }
            return new AuthInfoAccess(extVal, accessDescriptions);
        }
        catch (Asn1Exception e) {
            throw new IllegalArgumentException("Invalid CRL Distribution Points encoding.", e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, List<GeneralName>> entry : this.accessDescriptionMap.entrySet()) {
            if (entry.getKey().equals(OID_CA_ISSUERS)) {
                sb.append("caIssuers: ").append(entry.getValue()).append(",");
                continue;
            }
            if (entry.getKey().equals(OID_OCSP)) {
                sb.append("ocsp: ").append(entry.getValue()).append(",");
                continue;
            }
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append(",");
        }
        return sb.toString();
    }
}

