/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.pki.ocsp;

import com.oracle.jipher.pki.internal.AlgIdException;
import com.oracle.jipher.pki.internal.ExtensionHelper;
import com.oracle.jipher.pki.ocsp.CertId;
import com.oracle.jipher.tools.asn1.Asn1BerValue;
import com.oracle.jipher.tools.asn1.Asn1Exception;
import com.oracle.jipher.tools.asn1.UniversalTag;
import java.security.cert.CRLReason;
import java.security.cert.X509Extension;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CertResponse
implements X509Extension {
    private Status status;
    CertId certId;
    private Date revocationTime;
    private Date thisUpdate;
    private Date nextUpdate;
    private CRLReason reason;
    private Map<String, byte[]> extns;
    private Set<String> nonCriticalExtns;
    private Set<String> criticalExtns;

    private CertResponse(Status status, CertId certId) {
        this.status = status;
        this.certId = certId;
    }

    public Status getStatus() {
        return this.status;
    }

    public Date getRevocationTime() {
        return this.revocationTime;
    }

    public CRLReason getRevocationReason() {
        return this.reason;
    }

    public Date getThisUpdate() {
        return this.thisUpdate;
    }

    public Date getNextUpdate() {
        return this.nextUpdate;
    }

    public boolean isValid(Date date) {
        if (this.thisUpdate.getTime() > date.getTime()) {
            return false;
        }
        return this.nextUpdate == null || this.nextUpdate.getTime() > date.getTime();
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        return this.criticalExtns != null && !this.criticalExtns.isEmpty();
    }

    @Override
    public byte[] getExtensionValue(String oid) {
        if (this.extns == null) {
            return null;
        }
        byte[] val = this.extns.get(oid);
        if (val == null) {
            return null;
        }
        return (byte[])val.clone();
    }

    @Override
    public Set<String> getCriticalExtensionOIDs() {
        if (this.criticalExtns == null) {
            return null;
        }
        return Collections.unmodifiableSet(this.criticalExtns);
    }

    @Override
    public Set<String> getNonCriticalExtensionOIDs() {
        if (this.nonCriticalExtns == null) {
            return null;
        }
        return Collections.unmodifiableSet(this.nonCriticalExtns);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.status);
        if (this.reason != null) {
            sb.append("(").append((Object)this.reason).append(")");
        }
        sb.append(":").append(this.certId);
        return sb.toString();
    }

    static CertResponse decode(Asn1BerValue rspVal) throws AlgIdException {
        Status status;
        List<Asn1BerValue> singleRspContents = rspVal.tag(UniversalTag.SEQUENCE).count(3, 5).sequence();
        CertId certId = CertId.decode(singleRspContents.get(0));
        Asn1BerValue certStatus = singleRspContents.get(1);
        Date revTime = null;
        CRLReason reason = null;
        if (certStatus.hasTag(0)) {
            status = Status.NOT_REVOKED;
        } else if (certStatus.hasTag(1)) {
            status = Status.REVOKED;
            List<Asn1BerValue> timeReason = certStatus.tag(1).count(1, 2).sequence();
            revTime = timeReason.get(0).tag(UniversalTag.GeneralizedTime).getGeneralizedTime();
            if (timeReason.size() == 2) {
                reason = ExtensionHelper.getReason(timeReason.get(1).tag(0).explicit().tag(UniversalTag.ENUMERATED).getEnumerated().intValueExact());
            }
        } else if (certStatus.hasTag(2)) {
            status = Status.UNKNOWN;
        } else {
            throw new Asn1Exception("Invalid cert status tag value.");
        }
        CertResponse rsp = new CertResponse(status, certId);
        rsp.reason = reason;
        rsp.revocationTime = revTime;
        rsp.thisUpdate = singleRspContents.get(2).tag(UniversalTag.GeneralizedTime).getGeneralizedTime();
        int nextIndex = 3;
        if (singleRspContents.size() > nextIndex && singleRspContents.get(nextIndex).hasTag(0)) {
            rsp.nextUpdate = singleRspContents.get(nextIndex++).explicit().tag(UniversalTag.GeneralizedTime).getGeneralizedTime();
        }
        if (singleRspContents.size() > nextIndex) {
            rsp.criticalExtns = new HashSet<String>();
            rsp.nonCriticalExtns = new HashSet<String>();
            rsp.extns = ExtensionHelper.processExtns(singleRspContents.get(nextIndex).tag(1).explicit().sequence(), rsp.criticalExtns, rsp.nonCriticalExtns);
        }
        return rsp;
    }

    public static enum Status {
        REVOKED,
        NOT_REVOKED,
        UNKNOWN;

    }
}

