/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.pki.internal;

import java.io.File;
import java.security.cert.X509CRL;
import java.util.Date;
import java.util.zip.CRC32;
import javax.security.auth.x500.X500Principal;

public class CrlFileName {
    private static String crc32(byte[] bytes) {
        CRC32 crc = new CRC32();
        crc.update(bytes);
        return Long.toHexString(crc.getValue());
    }

    private static String issuerCode(X500Principal name) {
        return CrlFileName.crc32(name.getEncoded());
    }

    private static String dateCode(Date date) {
        return CrlFileName.crc32(String.valueOf(date.getTime()).getBytes());
    }

    public static String create(X509CRL crl, int suffix) {
        return CrlFileName.create(crl.getIssuerX500Principal(), crl.getThisUpdate(), suffix);
    }

    public static String create(X500Principal name, Date date, int suffix) {
        return "JG_" + CrlFileName.issuerCode(name) + "_" + CrlFileName.dateCode(date) + "_" + suffix + ".crl";
    }

    public static boolean isSupportedName(File f) {
        return f.getName().startsWith("JG_") && f.getName().endsWith(".crl");
    }

    public static boolean isForIssuer(File f, X500Principal issuer) {
        String[] nameParts = f.getName().split("_");
        if (nameParts.length < 3) {
            return false;
        }
        return nameParts[0].equals("JG") && nameParts[1].equals(CrlFileName.issuerCode(issuer));
    }

    public static boolean isForCrl(File f, X509CRL crl) {
        if (!CrlFileName.isSupportedName(f)) {
            return false;
        }
        String[] nameParts = f.getName().split("_");
        if (nameParts.length < 3) {
            return false;
        }
        return nameParts[1].equals(CrlFileName.issuerCode(crl.getIssuerX500Principal())) && nameParts[2].equals(CrlFileName.dateCode(crl.getThisUpdate()));
    }
}

