/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.spi;

import com.oracle.jipher.internal.common.Util;
import com.oracle.jipher.internal.fips.CryptoOp;
import com.oracle.jipher.internal.fips.Fips;
import com.oracle.jipher.internal.openssl.CipherCtx;
import com.oracle.jipher.internal.spi.CipherAlg;
import com.oracle.jipher.internal.spi.CipherMode;
import com.oracle.jipher.internal.spi.CipherPadding;
import com.oracle.jipher.internal.spi.InternalProvider;
import com.oracle.jipher.internal.spi.WrapUtil;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;

abstract class SymmCipher
extends CipherSpi {
    final CipherAlg cipherAlg;
    CipherMode mode = CipherMode.ECB;
    CipherPadding padding = CipherPadding.PKCS5PADDING;
    CipherCtx ctx;
    AlgorithmParameterSpec paramSpec;
    boolean encrypt;
    boolean updateCalled;
    static final int BOUNCE_BUFFER_SIZE = 16384;
    static final int MAX_BLOCK_SIZE = 16;

    SymmCipher(CipherAlg baseAlg) {
        this.cipherAlg = baseAlg;
    }

    @Override
    protected void engineSetMode(String s) throws NoSuchAlgorithmException {
        try {
            CipherMode mode = CipherMode.valueOf(s.toUpperCase());
            if (!this.cipherAlg.supportsMode(mode)) {
                throw new NoSuchAlgorithmException("Unsupported mode " + s);
            }
            this.mode = mode;
        }
        catch (IllegalArgumentException e) {
            throw new NoSuchAlgorithmException("Unsupported mode " + s);
        }
    }

    @Override
    protected void engineSetPadding(String s) throws NoSuchPaddingException {
        try {
            CipherPadding padding;
            CipherPadding cipherPadding = padding = "PKCS7PADDING".equalsIgnoreCase(s) ? CipherPadding.PKCS5PADDING : CipherPadding.valueOf(s.toUpperCase());
            if (!this.cipherAlg.supportsPadding(this.mode, padding)) {
                throw new NoSuchPaddingException("Unsupported padding " + s + " for mode " + (Object)((Object)this.mode));
            }
            this.padding = padding;
        }
        catch (IllegalArgumentException e) {
            throw new NoSuchPaddingException("Unsupported padding " + s);
        }
    }

    @Override
    protected int engineGetKeySize(Key key) {
        byte[] encoded = key.getEncoded();
        Util.clearArray(encoded);
        return encoded.length * 8;
    }

    @Override
    protected void engineInit(int cipherMode, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            this.engineInit(cipherMode, key, (AlgorithmParameterSpec)null, secureRandom);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidParameterException(e.getMessage());
        }
    }

    @Override
    protected void engineInit(int cipherMode, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.engineInit(cipherMode, key, this.convertParamsToSpec(algorithmParameters), secureRandom);
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        if (this.paramSpec == null) {
            return null;
        }
        try {
            AlgorithmParameters algParams = AlgorithmParameters.getInstance(this.getAlgorithmParametersAlg(), InternalProvider.get());
            algParams.init(this.paramSpec);
            return algParams;
        }
        catch (NoSuchAlgorithmException | InvalidParameterSpecException e) {
            throw new ProviderException("Unexpectedly, could not get parameters", e);
        }
    }

    abstract String getAlgorithmParametersAlg();

    abstract Class<? extends AlgorithmParameterSpec> getParameterSpecClass();

    private AlgorithmParameterSpec convertParamsToSpec(AlgorithmParameters params) throws InvalidAlgorithmParameterException {
        if (params == null) {
            return null;
        }
        try {
            return params.getParameterSpec(this.getParameterSpecClass());
        }
        catch (InvalidParameterSpecException e) {
            throw new InvalidAlgorithmParameterException("AlgorithmParameters invalid for algorithm, expected to retrieve " + this.getParameterSpecClass().getName());
        }
    }

    @Override
    protected void engineInit(int cipherMode, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.initInternal(key, algorithmParameterSpec, cipherMode == 1 || cipherMode == 3);
    }

    @Override
    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException {
        byte[] keyBytes = key.getEncoded();
        try {
            byte[] byArray = this.engineDoFinal(keyBytes, 0, keyBytes.length);
            return byArray;
        }
        catch (BadPaddingException e) {
            throw new IllegalBlockSizeException(e.getMessage());
        }
        finally {
            Util.clearArray(keyBytes);
        }
    }

    @Override
    protected Key engineUnwrap(byte[] wrappedKey, String keyAlg, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        Key key;
        byte[] keyBytes = null;
        try {
            keyBytes = this.engineDoFinal(wrappedKey, 0, wrappedKey.length);
            key = WrapUtil.createKey(keyAlg, wrappedKeyType, keyBytes);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            try {
                throw new InvalidKeyException("Failed to unwrap valid key");
            }
            catch (Throwable throwable) {
                Util.clearArray(keyBytes);
                throw throwable;
            }
        }
        Util.clearArray(keyBytes);
        return key;
    }

    abstract byte[] verifyParams(AlgorithmParameterSpec var1, boolean var2) throws InvalidAlgorithmParameterException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initInternal(Key key, AlgorithmParameterSpec params, boolean encrypt) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.cleanup();
        byte[] keyData = this.verifyKeyData(key);
        try {
            Fips.enforcement().checkStrength(encrypt ? CryptoOp.ENCRYPT_SYM : CryptoOp.DECRYPT_SYM, this.cipherAlg.getName(), keyData.length * 8);
            byte[] ivBytes = this.verifyParams(params, encrypt);
            if (this.ctx == null) {
                this.ctx = new CipherCtx();
            }
            this.ctx.init(this.cipherAlg.getAlg(keyData.length * 8, this.mode), this.padding == CipherPadding.PKCS5PADDING, encrypt, keyData, ivBytes);
            this.paramSpec = this.getParamSpec(ivBytes, params);
            this.encrypt = encrypt;
            this.updateCalled = false;
        }
        finally {
            Util.clearArray(keyData);
        }
    }

    abstract AlgorithmParameterSpec getParamSpec(byte[] var1, AlgorithmParameterSpec var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] verifyKeyData(Key key) throws InvalidKeyException {
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("Only SecretKey permitted.");
        }
        byte[] encoded = key.getEncoded();
        try {
            this.cipherAlg.validateKeySize(encoded.length);
            byte[] tmp = encoded;
            encoded = null;
            byte[] byArray = tmp;
            return byArray;
        }
        finally {
            Util.clearArray(encoded);
        }
    }

    @Override
    protected int engineUpdate(ByteBuffer input, ByteBuffer output) throws ShortBufferException {
        return super.engineUpdate(input, output);
    }

    @Override
    protected byte[] engineUpdate(byte[] input, int inOffset, int inLen) {
        byte[] out = new byte[this.getUpdateOutputSize(inLen)];
        try {
            int len = this.engineUpdate(input, inOffset, inLen, out, 0);
            if (len == out.length) {
                byte[] tmp = out;
                out = null;
                byte[] byArray = tmp;
                return byArray;
            }
            byte[] byArray = Arrays.copyOf(out, len);
            return byArray;
        }
        catch (ShortBufferException e) {
            throw new ProviderException("Internal error", e);
        }
        finally {
            Util.clearArray(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int updateInternal(byte[] input, int inOffset, int inLen, byte[] out, int outOffset, int outLen, boolean bufferedData) {
        boolean clearBounceBuffer = false;
        BufferOverlapState overlapState = SymmCipher.bufferOverlapState(input, inOffset, inLen, out, outOffset, outLen, bufferedData);
        if (overlapState != BufferOverlapState.DISJOINT && overlapState != BufferOverlapState.IN_PLACE) {
            input = Arrays.copyOfRange(input, inOffset, inOffset + inLen);
            inOffset = 0;
            clearBounceBuffer = this.encrypt;
        }
        try {
            int n = this.updateInternal(input, inOffset, inLen, out, outOffset);
            return n;
        }
        finally {
            if (clearBounceBuffer) {
                Util.clearArray(input);
            }
        }
    }

    int updateInternal(byte[] input, int inOffset, int inLen, byte[] out, int outOffset) {
        if (inLen > 0) {
            return this.ctx.update(input, inOffset, inLen, out, outOffset);
        }
        return 0;
    }

    abstract int getUpdateOutputSize(int var1);

    static boolean isOverlapping(byte[] input, int inOffset, int inLen, byte[] out, int outOffset, int outLen) {
        return input == out && outOffset < Math.addExact(inOffset, inLen) && inOffset < Math.addExact(outOffset, outLen);
    }

    static BufferOverlapState bufferOverlapState(byte[] input, int inOffset, int inLen, byte[] out, int outOffset, int outLen, boolean bufferedData) {
        if (!SymmCipher.isOverlapping(input, inOffset, inLen, out, outOffset, outLen)) {
            return BufferOverlapState.DISJOINT;
        }
        if (inOffset == outOffset && !bufferedData) {
            return BufferOverlapState.IN_PLACE;
        }
        if (inLen <= 16384 || outOffset <= inOffset && (!bufferedData || inOffset - outOffset >= 32)) {
            return BufferOverlapState.SINGLE_BOUNCE_BUF;
        }
        if (outOffset <= inOffset || !bufferedData || outOffset - inOffset <= 16352) {
            return BufferOverlapState.DOUBLE_BOUNCE_BUF;
        }
        return BufferOverlapState.COPY_ALL_INPUT;
    }

    @Override
    protected byte[] engineDoFinal(byte[] input, int inOffset, int inLen) throws IllegalBlockSizeException, BadPaddingException {
        byte[] out = new byte[this.engineGetOutputSize(inLen)];
        try {
            int len = this.engineDoFinal(input, inOffset, inLen, out, 0);
            if (len == out.length) {
                byte[] tmp = out;
                out = null;
                byte[] byArray = tmp;
                return byArray;
            }
            byte[] byArray = Arrays.copyOf(out, len);
            return byArray;
        }
        catch (ShortBufferException e) {
            throw new ProviderException("Internal error", e);
        }
        finally {
            Util.clearArray(out);
        }
    }

    @Override
    protected int engineDoFinal(ByteBuffer input, ByteBuffer output) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return super.engineDoFinal(input, output);
    }

    @Override
    protected byte[] engineGetIV() {
        try {
            return this.verifyParams(this.paramSpec, this.encrypt);
        }
        catch (InvalidAlgorithmParameterException e) {
            return null;
        }
    }

    @Override
    protected int engineGetBlockSize() {
        return this.cipherAlg.getBlockSize();
    }

    void cleanup() {
        if (this.ctx != null) {
            this.ctx.free();
            this.ctx = null;
        }
    }

    void checkIfInited() {
        if (this.ctx == null) {
            throw new IllegalStateException("Not initialized");
        }
    }

    static enum BufferOverlapState {
        DISJOINT,
        IN_PLACE,
        SINGLE_BOUNCE_BUF,
        DOUBLE_BOUNCE_BUF,
        COPY_ALL_INPUT;

    }
}

