/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.openssl;

import com.oracle.jipher.internal.openssl.MdAlg;
import com.oracle.jipher.internal.openssl.OpenSsl;
import com.oracle.jipher.internal.openssl.OpenSslException;
import com.oracle.jipher.internal.openssl.OsslFactory;
import com.oracle.jipher.internal.openssl.OsslObject;
import com.oracle.jipher.internal.openssl.Pkey;
import com.oracle.jipher.internal.openssl.PkeyAlgName;
import com.oracle.jipher.internal.openssl.PkeyType;
import java.security.InvalidKeyException;
import java.security.ProviderException;
import java.security.SignatureException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;

public abstract class PkeyCtx
extends OsslObject {
    public static void free(PkeyCtx ctx) {
        if (ctx != null) {
            ctx.free();
        }
    }

    PkeyCtx(State state) {
        super(state);
    }

    static State newState(PkeyAlgName algName) {
        OpenSsl openssl = OsslFactory.get();
        try {
            return new State(openssl, openssl.evpPkeyCtxNewName(algName.ordinal()));
        }
        catch (OpenSslException e) {
            throw new ProviderException("Failed to create OpenSSL object", e);
        }
    }

    static State newStatePE(Pkey pkey) {
        try {
            return new State(pkey.openssl, pkey.openssl.evpPkeyCtxNew(pkey));
        }
        catch (OpenSslException e) {
            throw new ProviderException("Failed to create OpenSSL object", e);
        }
    }

    static State newStateIKE(Pkey pkey) throws InvalidKeyException {
        try {
            return new State(pkey.openssl, pkey.openssl.evpPkeyCtxNew(pkey));
        }
        catch (OpenSslException e) {
            throw new InvalidKeyException("Failed to create OpenSSL object", e);
        }
    }

    public static final class Cipher
    extends PkeyCtx {
        public Cipher(Pkey pkey) throws ProviderException {
            super(Cipher.newStatePE(pkey));
        }

        public void init(boolean encrypt) throws ProviderException {
            try {
                this.openssl.evpPkeyCipherInitEx(this, encrypt);
            }
            catch (OpenSslException e) {
                throw new ProviderException(e);
            }
        }

        public void setPadding(int pad) {
            try {
                this.openssl.evpPkeyCtxSetRsaPadding(this, pad);
            }
            catch (OpenSslException e) {
                throw new ProviderException(e);
            }
        }

        public void setOaepParams(MdAlg md, MdAlg mgf1Md, byte[] pVal) {
            try {
                this.openssl.evpPkeyCtxSetOaepParamsEx(this, md.getAlg(), mgf1Md.getAlg(), pVal);
            }
            catch (OpenSslException e) {
                throw new ProviderException(e);
            }
        }

        public int encrypt(byte[] input, int offset, int len, byte[] output, int outOffset) throws IllegalBlockSizeException {
            try {
                return this.openssl.evpPkeyCipherFinalEx(this, true, input, offset, len, output, outOffset);
            }
            catch (OpenSslException e) {
                IllegalBlockSizeException ibse = new IllegalBlockSizeException(e.getMessage());
                ibse.initCause(e);
                throw ibse;
            }
        }

        public int decrypt(byte[] input, int offset, int len, byte[] output, int outOffset) throws BadPaddingException {
            try {
                return this.openssl.evpPkeyCipherFinalEx(this, false, input, offset, len, output, outOffset);
            }
            catch (OpenSslException e) {
                BadPaddingException bpe = new BadPaddingException(e.getMessage());
                bpe.initCause(e);
                throw bpe;
            }
        }
    }

    public static final class Signature
    extends PkeyCtx {
        public Signature(Pkey pkey) throws InvalidKeyException {
            super(Signature.newStateIKE(pkey));
        }

        public void signInit() throws InvalidKeyException {
            try {
                this.openssl.evpPkeySignInit(this);
            }
            catch (OpenSslException e) {
                throw new InvalidKeyException(e);
            }
        }

        public void verifyInit() throws InvalidKeyException {
            try {
                this.openssl.evpPkeyVerifyInit(this);
            }
            catch (OpenSslException e) {
                throw new InvalidKeyException(e);
            }
        }

        public byte[] sign(byte[] input, int offset, int len) throws SignatureException {
            try {
                return this.openssl.evpPkeySign(this, input, offset, len);
            }
            catch (OpenSslException e) {
                throw new SignatureException(e);
            }
        }

        public boolean verify(byte[] signature, int sigOff, int sigLen, byte[] input, int off, int len) throws SignatureException {
            try {
                return this.openssl.evpPkeyVerify(this, signature, sigOff, sigLen, input, off, len);
            }
            catch (OpenSslException e) {
                throw new SignatureException(e);
            }
        }
    }

    public static final class Derive
    extends PkeyCtx {
        public Derive(Pkey pkey) throws InvalidKeyException {
            super(Derive.newStateIKE(pkey));
            try {
                this.openssl.evpPkeyDeriveInit(this);
            }
            catch (OpenSslException e) {
                throw new InvalidKeyException(e);
            }
        }

        public byte[] derive(Pkey peer) throws InvalidKeyException {
            try {
                return this.openssl.evpPkeyDerive(this, peer);
            }
            catch (OpenSslException e) {
                throw new InvalidKeyException(e);
            }
        }
    }

    public static final class DsaParamGen
    extends PkeyCtx {
        private int pLen;
        private int qLen;

        public DsaParamGen() {
            super(DsaParamGen.newState(PkeyAlgName.DSA));
        }

        public void setParams(int pBits, int qBits) {
            this.pLen = pBits;
            this.qLen = qBits;
        }

        public Pkey generate() {
            if (this.pLen == 0) {
                throw new IllegalStateException("setParams must be called");
            }
            try {
                this.openssl.evpParamGenInit(this);
                this.openssl.evpPkeyCtxSetDsaParamgenBits(this, this.pLen, this.qLen);
                return new Pkey(this.openssl, this.openssl.evpParamGen(this), PkeyType.DSA);
            }
            catch (OpenSslException e) {
                throw new ProviderException(e);
            }
        }
    }

    public static final class DhKeyGen
    extends KeyGen {
        public DhKeyGen(Pkey params) {
            super(DhKeyGen.newStatePE(params), PkeyType.DH);
        }
    }

    public static final class DsaKeyGen
    extends KeyGen {
        public DsaKeyGen(Pkey params) {
            super(DsaKeyGen.newStatePE(params), PkeyType.DSA);
        }
    }

    public static final class EcKeyGen
    extends KeyGen {
        public EcKeyGen(Pkey params) {
            super(EcKeyGen.newStatePE(params), PkeyType.EC);
        }
    }

    public static final class RsaKeyGen
    extends KeyGen {
        private int bits;
        private byte[] exp;

        public RsaKeyGen() {
            super(RsaKeyGen.newState(PkeyAlgName.RSA), PkeyType.RSA);
        }

        public void setParams(int keyBits, byte[] pubExp) {
            this.bits = keyBits;
            this.exp = pubExp;
        }

        @Override
        void initParams() throws OpenSslException {
            this.openssl.evpPkeyCtxSetRsaKeyGenBits(this, this.bits);
            if (this.exp != null) {
                this.openssl.evpPkeyCtxSetRsaKeyGenPubExp(this, this.exp);
            }
        }

        @Override
        public Pkey[] generate() {
            if (this.bits == 0) {
                throw new IllegalStateException("setParams was not called.");
            }
            return super.generate();
        }
    }

    public static abstract class KeyGen
    extends PkeyCtx {
        final PkeyType type;

        KeyGen(State state, PkeyType type) {
            super(state);
            this.type = type;
        }

        void initParams() throws OpenSslException {
        }

        public Pkey[] generate() {
            Pkey[] kp = new Pkey[2];
            try {
                this.openssl.evpKeyGenInit(this);
                this.initParams();
                kp[0] = new Pkey(this.openssl, this.openssl.evpKeyGen(this), this.type);
                kp[1] = kp[0].createPub();
                return kp;
            }
            catch (OpenSslException e) {
                Pkey.free(kp);
                throw new ProviderException(e);
            }
        }
    }

    static class State
    extends OsslObject.BaseState {
        State(OpenSsl openssl, long ptr) {
            super(openssl, ptr);
        }

        @Override
        void free(long ptr) {
            this.openssl.evpPkeyCtxFree(ptr);
        }
    }
}

