/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.openssl;

public enum MdAlg {
    SHA1("SHA-1"),
    SHA224("SHA-224"),
    SHA256("SHA-256"),
    SHA384("SHA-384"),
    SHA512("SHA-512"),
    SHA3_224("SHA3-224"),
    SHA3_256("SHA3-256"),
    SHA3_384("SHA3-384"),
    SHA3_512("SHA3-512");

    private String name;

    private MdAlg(String name) {
        this.name = name;
    }

    public String getAlg() {
        return this.name;
    }

    public static MdAlg byName(String alg) {
        for (MdAlg md : MdAlg.values()) {
            if (!md.name.equalsIgnoreCase(alg)) continue;
            return md;
        }
        return null;
    }
}

