/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.common;

import java.security.AccessController;
import java.security.PrivilegedAction;

public class Jre {
    private static final String VENDOR_STRING = Jre.systemProperty("java.vendor");
    private static final String RUNTIME_STRING = Jre.systemProperty("java.runtime.name");

    private static String systemProperty(final String prop) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(prop);
            }
        });
    }

    public static Vendor getVendor() {
        if (VENDOR_STRING.startsWith("IBM")) {
            return Vendor.IBM;
        }
        if (VENDOR_STRING.startsWith("Hewlett")) {
            return Vendor.HP;
        }
        return Vendor.ORACLE;
    }

    public static boolean isSemeru() {
        return RUNTIME_STRING.contains("Semeru");
    }

    public static enum Vendor {
        ORACLE,
        IBM,
        HP;

    }
}

