/*
 * Copyright (c) 2023, 2023, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package com.oracle.svm.core.jni.headers;

import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.c.constant.CConstant;

import com.oracle.svm.core.util.BasedOnJDKFile;

import jdk.graal.compiler.serviceprovider.JavaVersionUtil;

final class JNIHeaderDirectivesJDKLatest extends JNIHeaderDirectives {
    @Override
    public boolean isInConfiguration() {
        return JavaVersionUtil.JAVA_SPEC > 21;
    }
}

@CContext(JNIHeaderDirectivesJDKLatest.class)
public final class JNIVersionJDKLatest {

    // Checkstyle: stop

    @CConstant
    public static native int JNI_VERSION_24();

    /*
     * GR-50948: there is not yet a JNI_VERSION_XX constant defined for JDK latest. As soon as it
     * gets available, the "value" property of the CConstant annotation below must be removed.
     */
    @CConstant(value = "JNI_VERSION_24")
    @BasedOnJDKFile("https://github.com/openjdk/jdk/blob/jdk-24+16/src/java.base/share/native/include/jni.h#L1994-L2006")
    public static native int JNI_VERSION_LATEST();

    // Checkstyle: resume

    private JNIVersionJDKLatest() {
    }
}
