/*
 * Copyright (c) 1998, 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

/**
 * Allows developers to provide support for undo/redo in applications such as
 * text editors.
 * <p>
 * <strong>Note:</strong>
 * Most of the Swing API is <em>not</em> thread safe. For details, see
 * <a
 * href="https://docs.oracle.com/javase/tutorial/uiswing/concurrency/index.html"
 * target="_top">Concurrency in Swing</a>,
 * a section in
 * <em><a href="https://docs.oracle.com/javase/tutorial/"
 * target="_top">The Java Tutorial</a></em>.
 *
 * <h2>Related Documentation</h2>
 * For overviews, tutorials, examples, guides, and tool documentation,
 * please see:
 * <ul>
 *     <li><a href="https://docs.oracle.com/javase/tutorial/uiswing/components/generaltext.html#undo"
 *     target="_top">Implementing Undo and Redo</a>,
 *     a section in <em>The Java Tutorial</em></li>
 * </ul>
 *
 * @since 1.2
 * @serial exclude
 */
package javax.swing.undo;
