/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.aotjs.api;

import java.math.BigInteger;
import org.graalvm.aotjs.api.JSUndefined;

public abstract class JSValue {
    JSValue() {
    }

    public static JSUndefined undefined() {
        return JSUndefined.instance();
    }

    public abstract String typeof();

    protected abstract String stringValue();

    public Boolean asBoolean() {
        throw this.classCastError("Boolean");
    }

    public Byte asByte() {
        throw this.classCastError("Byte");
    }

    public Short asShort() {
        throw this.classCastError("Short");
    }

    public Character asChar() {
        throw this.classCastError("Character");
    }

    public Integer asInt() {
        throw this.classCastError("Integer");
    }

    public Float asFloat() {
        throw this.classCastError("Float");
    }

    public Long asLong() {
        throw this.classCastError("Long");
    }

    public Double asDouble() {
        throw this.classCastError("Double");
    }

    public BigInteger asBigInteger() {
        throw this.classCastError(BigInteger.class.getName());
    }

    public String asString() {
        throw this.classCastError("String");
    }

    public boolean[] asBooleanArray() {
        throw this.classCastError("boolean[]");
    }

    public byte[] asByteArray() {
        throw this.classCastError("byte[]");
    }

    public short[] asShortArray() {
        throw this.classCastError("short[]");
    }

    public char[] asCharArray() {
        throw this.classCastError("char[]");
    }

    public int[] asIntArray() {
        throw this.classCastError("int[]");
    }

    public float[] asFloatArray() {
        throw this.classCastError("float[]");
    }

    public long[] asLongArray() {
        throw this.classCastError("long[]");
    }

    public double[] asDoubleArray() {
        throw this.classCastError("double[]");
    }

    public <T> T as(Class<T> cls) {
        if (cls.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        if (Number.class.isAssignableFrom(cls)) {
            if (Integer.class.equals(cls)) {
                return (T)this.asInt();
            }
            if (Float.class.equals(cls)) {
                return (T)this.asFloat();
            }
            if (Long.class.equals(cls)) {
                return (T)this.asLong();
            }
            if (Double.class.equals(cls)) {
                return (T)this.asDouble();
            }
            if (Byte.class.equals(cls)) {
                return (T)this.asByte();
            }
            if (Short.class.equals(cls)) {
                return (T)this.asShort();
            }
            if (BigInteger.class.equals(cls)) {
                return (T)this.asBigInteger();
            }
        }
        if (String.class.equals(cls)) {
            return (T)this.asString();
        }
        if (cls.isArray() && cls.getComponentType().isPrimitive()) {
            if (int[].class.equals(cls)) {
                return (T)this.asIntArray();
            }
            if (float[].class.equals(cls)) {
                return (T)this.asFloatArray();
            }
            if (long[].class.equals(cls)) {
                return (T)this.asLongArray();
            }
            if (double[].class.equals(cls)) {
                return (T)this.asDoubleArray();
            }
            if (byte[].class.equals(cls)) {
                return (T)this.asByteArray();
            }
            if (short[].class.equals(cls)) {
                return (T)this.asShortArray();
            }
            if (char[].class.equals(cls)) {
                return (T)this.asCharArray();
            }
            if (boolean[].class.equals(cls)) {
                return (T)this.asBooleanArray();
            }
        }
        if (Character.class.equals(cls)) {
            return (T)this.asChar();
        }
        if (Boolean.class.equals(cls)) {
            return (T)this.asBoolean();
        }
        throw this.classCastError(cls.getName());
    }

    private ClassCastException classCastError(String type) {
        throw new ClassCastException("JavaScript '" + this.typeof() + "' value cannot be coerced to a Java '" + type + "'.");
    }

    public String toString() {
        return "JavaScript<" + this.typeof() + "; " + this.stringValue() + ">";
    }
}

