/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.aotjs.api;

import org.graalvm.aotjs.api.JS;
import org.graalvm.aotjs.api.JSBoolean;
import org.graalvm.aotjs.api.JSString;
import org.graalvm.aotjs.api.JSValue;

public class JSObject
extends JSValue {
    @JS(value="return createAnonymousJavaScriptObject();")
    public static native JSObject create();

    @JS(value="return obj0 === obj1;")
    private static native JSBoolean referenceEquals(JSObject var0, JSObject var1);

    protected JSObject() {
    }

    @JS(value="return typeof this;")
    public native JSString typeofString();

    @Override
    public String typeof() {
        return this.typeofString().asString();
    }

    @Override
    @JS(value="return toProxy(toJavaString(this.toString()));")
    protected native String stringValue();

    @JS(value="return this[key];")
    public native Object get(Object var1);

    @JS(value="this[key] = newValue;")
    public native void set(Object var1, Object var2);

    @JS(value="return Object.keys(this);")
    public native Object keys();

    @JS(value="return this.apply(this, extractJavaScriptArray(args[runtime.symbol.javaNative]));")
    public native Object invoke(Object ... var1);

    @JS(value="return this.apply(thisArg, extractJavaScriptArray(args[runtime.symbol.javaNative]));")
    public native Object call(Object var1, Object ... var2);

    private ClassCastException classCastException(String targetType) {
        return new ClassCastException(String.valueOf(this) + " cannot be coerced to '" + targetType + "'.");
    }

    @JS(value="if (this.constructor === Uint8Array) { this.hub = booleanArrayHub; return toProxy(this); } else { return null; };")
    private native boolean[] extractBooleanArray();

    @Override
    public boolean[] asBooleanArray() {
        boolean[] array = this.extractBooleanArray();
        if (array != null) {
            return array;
        }
        throw this.classCastException("boolean[]");
    }

    @JS(value="if (this.constructor === Int8Array) { this.hub = byteArrayHub; return toProxy(this); } else { return null; };")
    private native byte[] extractByteArray();

    @Override
    public byte[] asByteArray() {
        byte[] array = this.extractByteArray();
        if (array != null) {
            return array;
        }
        throw this.classCastException("byte[]");
    }

    @JS(value="if (this.constructor === Int16Array) { this.hub = shortArrayHub; return toProxy(this); } else { return null; };")
    private native short[] extractShortArray();

    @Override
    public short[] asShortArray() {
        short[] array = this.extractShortArray();
        if (array != null) {
            return array;
        }
        throw this.classCastException("short[]");
    }

    @JS(value="if (this.constructor === Uint16Array) { this.hub = charArrayHub; return toProxy(this); } else { return null; };")
    private native char[] extractCharArray();

    @Override
    public char[] asCharArray() {
        char[] array = this.extractCharArray();
        if (array != null) {
            return array;
        }
        throw this.classCastException("char[]");
    }

    @JS(value="if (this.constructor === Int32Array) { this.hub = intArrayHub; return toProxy(this); } else { return null; };")
    private native int[] extractIntArray();

    @Override
    public int[] asIntArray() {
        int[] array = this.extractIntArray();
        if (array != null) {
            return array;
        }
        throw this.classCastException("int[]");
    }

    @JS(value="if (this.constructor === Float32Array) { this.hub = floatArrayHub; return toProxy(this); } else { return null; };")
    private native float[] extractFloatArray();

    @Override
    public float[] asFloatArray() {
        float[] array = this.extractFloatArray();
        if (array != null) {
            return array;
        }
        throw this.classCastException("float[]");
    }

    @JS(value="if (this.constructor === BigInt64Array) { this.hub = longArrayHub; initComponentView(this); return toProxy(this); } else { return null; };")
    private native long[] extractLongArray();

    @Override
    public long[] asLongArray() {
        long[] array = this.extractLongArray();
        if (array != null) {
            return array;
        }
        throw this.classCastException("long[]");
    }

    @JS(value="if (this.constructor === Float64Array) { this.hub = doubleArrayHub; return toProxy(this); } else { return null; };")
    private native double[] extractDoubleArray();

    @Override
    public double[] asDoubleArray() {
        double[] array = this.extractDoubleArray();
        if (array != null) {
            return array;
        }
        throw this.classCastException("double[]");
    }

    @JS(value="return tryExtractFacadeClass(this, cls);")
    private native <T> T extractFacadeClass(Class<?> var1);

    @Override
    public <T> T as(Class<T> cls) {
        T facade = this.extractFacadeClass(cls);
        if (facade != null) {
            return facade;
        }
        return super.as(cls);
    }

    public boolean equalsJavaScript(JSObject that) {
        return JSObject.referenceEquals(this, that).asBoolean();
    }
}

