/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.aotjs.api;

import java.math.BigInteger;
import org.graalvm.aotjs.api.JS;
import org.graalvm.aotjs.api.JSValue;

public final class JSBigInt
extends JSValue {
    JSBigInt() {
    }

    @JS(value="return BigInt(extractJavaScriptString(s[runtime.symbol.javaNative]));")
    private static native JSBigInt of(String var0);

    public static JSBigInt of(long n) {
        return JSBigInt.of(String.valueOf(n));
    }

    public static JSBigInt of(BigInteger b) {
        return JSBigInt.of(b.toString());
    }

    @Override
    public String typeof() {
        return "bigint";
    }

    @JS(value="return toProxy(toJavaString(this.toString()));")
    private native String javaString();

    @Override
    protected String stringValue() {
        return this.javaString();
    }

    private BigInteger bigInteger() {
        return new BigInteger(this.javaString());
    }

    @Override
    public Byte asByte() {
        return this.bigInteger().byteValue();
    }

    @Override
    public Short asShort() {
        return this.bigInteger().shortValue();
    }

    @Override
    public Character asChar() {
        return Character.valueOf((char)this.bigInteger().intValue());
    }

    @Override
    public Integer asInt() {
        return this.bigInteger().intValue();
    }

    @Override
    public Float asFloat() {
        return Float.valueOf(this.bigInteger().floatValue());
    }

    @Override
    public Long asLong() {
        return this.bigInteger().longValue();
    }

    @Override
    public BigInteger asBigInteger() {
        return this.bigInteger();
    }

    public boolean equals(Object that) {
        if (that instanceof JSBigInt) {
            return this.javaString().equals(((JSBigInt)that).javaString());
        }
        return false;
    }

    public int hashCode() {
        return this.javaString().hashCode();
    }
}

