/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.substitute;

import com.oracle.graal.pointsto.util.GraalAccess;
import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.fieldvaluetransformer.FieldValueTransformerWithAvailability;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.substitute.TranslateFieldOffsetFieldValueTransformer;
import java.lang.reflect.Modifier;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;

public record AtomicFieldUpdaterOffsetFieldValueTransformer(ResolvedJavaField original, Class<?> updaterClass) implements FieldValueTransformerWithAvailability
{
    @Override
    public boolean isAvailable() {
        return BuildPhaseProvider.isHostedUniverseBuilt();
    }

    public Object transform(Object receiver, Object originalValue) {
        assert (!Modifier.isStatic(this.original.getModifiers()));
        ResolvedJavaField tclassField = AtomicFieldUpdaterOffsetFieldValueTransformer.findField(this.original.getDeclaringClass(), "tclass");
        SnippetReflectionProvider originalSnippetReflection = GraalAccess.getOriginalSnippetReflection();
        JavaConstant receiverConstant = GraalAccess.getOriginalSnippetReflection().forObject(receiver);
        Class tclass = (Class)originalSnippetReflection.asObject(Class.class, GraalAccess.getOriginalProviders().getConstantReflection().readFieldValue(tclassField, receiverConstant));
        return TranslateFieldOffsetFieldValueTransformer.translateFieldOffset(this.original, receiverConstant, tclass);
    }

    private static ResolvedJavaField findField(ResolvedJavaType declaringClass, String name) {
        for (ResolvedJavaField field : declaringClass.getInstanceFields(false)) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        throw VMError.shouldNotReachHere("Field not found: " + declaringClass.toJavaName(true) + "." + name);
    }
}

