/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.hosted;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.deopt.DeoptimizationCanaryFeature;
import com.oracle.svm.core.deopt.DeoptimizationCounters;
import com.oracle.svm.core.deopt.DeoptimizationRuntime;
import com.oracle.svm.core.deopt.DeoptimizationSupport;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.graal.snippets.DeoptTestSnippets;
import com.oracle.svm.core.graal.snippets.DeoptTester;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.core.util.CounterFeature;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.InternalPlatform;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

@Platforms(value={InternalPlatform.NATIVE_ONLY.class})
public final class DeoptimizationFeature
implements InternalFeature {
    private static final Method deoptStubMethod;

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return List.of(DeoptimizationCanaryFeature.class, CounterFeature.class);
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageSingletons.add(DeoptimizationSupport.class, (Object)new DeoptimizationSupport());
        ImageSingletons.add(DeoptimizationCounters.class, (Object)new DeoptimizationCounters());
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess a) {
        FeatureImpl.BeforeAnalysisAccessImpl access = (FeatureImpl.BeforeAnalysisAccessImpl)a;
        access.registerAsRoot(deoptStubMethod, true, "Deoptimization stub, registered in " + String.valueOf(DeoptimizationFeature.class), new MultiMethod.MultiMethodKey[0]);
        access.registerAsRoot((AnalysisMethod)DeoptimizationRuntime.DEOPTIMIZE.findMethod((MetaAccessProvider)access.getMetaAccess()), true, "Deoptimization, registered in " + String.valueOf(DeoptimizationFeature.class), new MultiMethod.MultiMethodKey[0]);
        if (DeoptTester.enabled()) {
            access.getBigBang().addRootMethod((AnalysisMethod)DeoptTester.DEOPTTEST.findMethod((MetaAccessProvider)access.getMetaAccess()), true, (Object)("Deoptimization test, registered in " + String.valueOf(DeoptimizationFeature.class)), new MultiMethod.MultiMethodKey[0]);
        }
    }

    @Override
    public void registerForeignCalls(SubstrateForeignCallsProvider foreignCalls) {
        foreignCalls.register(DeoptimizationRuntime.DEOPTIMIZE);
        if (DeoptTester.enabled()) {
            foreignCalls.register(DeoptTester.DEOPTTEST);
        }
    }

    @Override
    public void registerLowerings(RuntimeConfiguration runtimeConfig, OptionValues options, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings, boolean hosted) {
        if (DeoptTester.enabled()) {
            DeoptTestSnippets.registerLowerings(options, providers, lowerings);
        }
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess a) {
        FeatureImpl.CompilationAccessImpl config = (FeatureImpl.CompilationAccessImpl)a;
        config.registerAsImmutable(ImageSingletons.lookup(DeoptimizationSupport.class));
        HostedMetaAccess metaAccess = config.getMetaAccess();
        DeoptimizationSupport.setDeoptStubPointer(new MethodPointer(metaAccess.lookupJavaMethod(deoptStubMethod)));
    }

    static {
        try {
            deoptStubMethod = Deoptimizer.class.getMethod("deoptStub", Pointer.class, UnsignedWord.class, UnsignedWord.class);
        }
        catch (NoSuchMethodException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }
}

