/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal;

import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.graal.RuntimeCPUFeatureRegion;
import com.oracle.svm.graal.aarch64.AArch64CPUFeatureRegionOp;
import com.oracle.svm.graal.amd64.AMD64CPUFeatureRegionOp;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.EnumSet;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.gen.LIRGenerator;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugins;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.graal.compiler.phases.util.Providers;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;

@AutomaticallyRegisteredFeature
class RuntimeCPUFeatureRegionFeature
implements InternalFeature {
    RuntimeCPUFeatureRegionFeature() {
    }

    @Override
    public void registerInvocationPlugins(Providers providers, GraphBuilderConfiguration.Plugins plugins, ParsingReason reason) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins.getInvocationPlugins(), RuntimeCPUFeatureRegion.class, providers.getReplacements());
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInlineOnlyInvocationPlugin(this, "enter", new Type[]{Enum.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg0) {
                return RuntimeCPUFeatureRegionFeature.createRegionEnterNode(b, arg0, new ValueNode[0]);
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInlineOnlyInvocationPlugin(this, "enter", new Type[]{Enum.class, Enum.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg0, ValueNode arg1) {
                return RuntimeCPUFeatureRegionFeature.createRegionEnterNode(b, arg0, arg1);
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInlineOnlyInvocationPlugin(this, "enter", new Type[]{Enum.class, Enum.class, Enum.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg0, ValueNode arg1, ValueNode arg2) {
                return RuntimeCPUFeatureRegionFeature.createRegionEnterNode(b, arg0, arg1, arg2);
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInlineOnlyInvocationPlugin(this, "enterSet", new Type[]{EnumSet.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg0) {
                return RuntimeCPUFeatureRegionFeature.createRegionEnterSetNode(b, arg0);
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInlineOnlyInvocationPlugin(this, "leave", new Type[]{InvocationPlugin.Receiver.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                receiver.get(true);
                b.add((Node)new CPUFeatureRegionLeaveNode());
                return true;
            }
        });
    }

    private static boolean createRegionEnterNode(GraphBuilderContext b, ValueNode first, ValueNode ... rest) {
        Enum<?> firstEnum = RuntimeCPUFeatureRegionFeature.constValueToEnum(b, first);
        Enum[] restEnum = (Enum[])Arrays.stream(rest).map(n -> RuntimeCPUFeatureRegionFeature.constValueToEnum(b, n)).toArray(Enum[]::new);
        EnumSet<?> features = RuntimeCPUFeatureRegionFeature.toEnumSet(firstEnum, restEnum);
        b.add((Node)new CPUFeatureRegionEnterNode(features));
        b.addPush(JavaKind.Object, (ValueNode)ConstantNode.forConstant((JavaConstant)b.getSnippetReflection().forObject((Object)RuntimeCPUFeatureRegion.INSTANCE), (MetaAccessProvider)b.getMetaAccess()));
        return true;
    }

    private static boolean createRegionEnterSetNode(GraphBuilderContext b, ValueNode set) {
        GraalError.guarantee((boolean)set.isConstant(), (String)"Must be a constant: %s", (Object)set);
        EnumSet features = (EnumSet)b.getSnippetReflection().asObject(EnumSet.class, set.asJavaConstant());
        b.add((Node)new CPUFeatureRegionEnterNode(features));
        b.addPush(JavaKind.Object, (ValueNode)ConstantNode.forConstant((JavaConstant)b.getSnippetReflection().forObject((Object)RuntimeCPUFeatureRegion.INSTANCE), (MetaAccessProvider)b.getMetaAccess()));
        return true;
    }

    private static Enum<?> constValueToEnum(GraphBuilderContext b, ValueNode node) {
        GraalError.guarantee((boolean)node.isConstant(), (String)"Must be a constant: %s", (Object)node);
        return (Enum)b.getSnippetReflection().asObject(Enum.class, node.asJavaConstant());
    }

    private static EnumSet<?> toEnumSet(Enum first, Enum ... rest) {
        return EnumSet.of(first, rest);
    }

    @NodeInfo(nameTemplate="CPUFeatureRegionEnter {p#features}", cycles=NodeCycles.CYCLES_0, cyclesRationale="no code is generated for this node", size=NodeSize.SIZE_0, sizeRationale="no code is generated for this node")
    public static class CPUFeatureRegionEnterNode
    extends FixedWithNextNode
    implements LIRLowerable {
        public static final NodeClass<CPUFeatureRegionEnterNode> TYPE = NodeClass.create(CPUFeatureRegionEnterNode.class);
        private final EnumSet<?> features;

        protected CPUFeatureRegionEnterNode(EnumSet<?> features) {
            super(TYPE, StampFactory.objectNonNull());
            this.features = features;
        }

        private static <T extends Enum<T>> EnumSet<T> checkedCast(EnumSet<?> features, Class<T> enumClass) {
            if (!features.isEmpty()) {
                GraalError.guarantee((boolean)enumClass.isInstance(features.iterator().next()), (String)"Wrong enum set: %s vs. %s", enumClass, features);
            }
            return features;
        }

        public void generate(NodeLIRBuilderTool tool) {
            Architecture arch = ConfigurationValues.getTarget().arch;
            if (arch instanceof AMD64) {
                LIRGenerator generator = (LIRGenerator)tool.getLIRGeneratorTool();
                generator.append((LIRInstruction)new AMD64CPUFeatureRegionOp.AMD64CPUFeatureRegionEnterOp(CPUFeatureRegionEnterNode.checkedCast(this.features, AMD64.CPUFeature.class)));
            } else if (arch instanceof AArch64) {
                LIRGenerator generator = (LIRGenerator)tool.getLIRGeneratorTool();
                generator.append((LIRInstruction)new AArch64CPUFeatureRegionOp.AArch64CPUFeatureRegionEnterOp(CPUFeatureRegionEnterNode.checkedCast(this.features, AArch64.CPUFeature.class)));
            } else {
                throw GraalError.shouldNotReachHere((String)("unsupported architecture " + String.valueOf(arch)));
            }
        }
    }

    @NodeInfo(nameTemplate="CPUFeatureRegionLeave", cycles=NodeCycles.CYCLES_0, cyclesRationale="no code is generated for this node", size=NodeSize.SIZE_0, sizeRationale="no code is generated for this node")
    public static class CPUFeatureRegionLeaveNode
    extends FixedWithNextNode
    implements LIRLowerable {
        public static final NodeClass<CPUFeatureRegionLeaveNode> TYPE = NodeClass.create(CPUFeatureRegionLeaveNode.class);

        protected CPUFeatureRegionLeaveNode() {
            super(TYPE, StampFactory.forVoid());
        }

        public void generate(NodeLIRBuilderTool tool) {
            Architecture arch = ConfigurationValues.getTarget().arch;
            if (arch instanceof AMD64) {
                LIRGenerator generator = (LIRGenerator)tool.getLIRGeneratorTool();
                generator.append((LIRInstruction)new AMD64CPUFeatureRegionOp.AMD64CPUFeatureRegionLeaveOp());
            } else if (arch instanceof AArch64) {
                LIRGenerator generator = (LIRGenerator)tool.getLIRGeneratorTool();
                generator.append((LIRInstruction)new AArch64CPUFeatureRegionOp.AArch64CPUFeatureRegionLeaveOp());
            } else {
                throw GraalError.shouldNotReachHere((String)("unsupported architecture " + String.valueOf(arch)));
            }
        }
    }
}

