/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.locks;

import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.locks.ClassInstanceReplacer;
import com.oracle.svm.core.locks.VMCondition;
import com.oracle.svm.core.locks.VMLockSupport;
import com.oracle.svm.core.locks.VMMutex;
import com.oracle.svm.core.locks.VMSemaphore;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
final class VMLockFeature
implements InternalFeature {
    VMLockFeature() {
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        if (!ImageSingletons.contains(VMLockSupport.class)) {
            return;
        }
        VMLockSupport support = (VMLockSupport)ImageSingletons.lookup(VMLockSupport.class);
        support.mutexReplacer = new ClassInstanceReplacer<VMMutex, VMMutex>(VMMutex.class, support.mutexes, support::replaceVMMutex);
        support.conditionReplacer = new ClassInstanceReplacer<VMCondition, VMCondition>(VMCondition.class, support.conditions, support::replaceVMCondition);
        support.semaphoreReplacer = new ClassInstanceReplacer<VMSemaphore, VMSemaphore>(VMSemaphore.class, support.semaphores, support::replaceSemaphore);
        access.registerObjectReplacer(support.mutexReplacer);
        access.registerObjectReplacer(support.conditionReplacer);
        access.registerObjectReplacer(support.semaphoreReplacer);
    }
}

