/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.resources.CompressedGlobTrie;

import com.oracle.svm.core.jdk.resources.CompressedGlobTrie.GlobTrieNode;

final class StarTrieNode<C>
extends GlobTrieNode<C> {
    private final boolean matchingWholeLevel;

    StarTrieNode(String content) {
        super(content);
        this.matchingWholeLevel = false;
    }

    StarTrieNode(boolean matchesWholeLevel) {
        super("*");
        this.matchingWholeLevel = matchesWholeLevel;
    }

    public boolean isMatchingWholeLevel() {
        return this.matchingWholeLevel;
    }

    public boolean hasChildrenOnThisLevel() {
        return this.getChildren().stream().anyMatch(child -> !child.isNewLevel());
    }
}

