/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.localization.substitutions;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.jdk.localization.LocalizationSupport;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.graalvm.nativeimage.ImageSingletons;

@TargetClass(value=Charset.class)
public final class Target_java_nio_charset_Charset {
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    private static volatile Object[] cache1;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    private static volatile Object[] cache2;

    @Substitute
    private static Charset defaultCharset() {
        return ((LocalizationSupport)ImageSingletons.lookup(LocalizationSupport.class)).defaultCharset;
    }

    @Substitute
    private static SortedMap<String, Charset> availableCharsets() {
        TreeMap<String, Charset> result = new TreeMap<String, Charset>(String.CASE_INSENSITIVE_ORDER);
        Map<String, Charset> charsets = ((LocalizationSupport)ImageSingletons.lookup(LocalizationSupport.class)).charsets;
        for (Charset charset : charsets.values()) {
            result.put(charset.name(), charset);
        }
        return Collections.unmodifiableSortedMap(result);
    }

    @Alias
    public static native Charset forName(String var0, Charset var1);

    @Substitute
    private static Charset lookup2(String charsetName) {
        Object[] a = cache2;
        if (cache2 != null && charsetName.equals(a[0])) {
            cache2 = cache1;
            cache1 = a;
            return (Charset)a[1];
        }
        Map<String, Charset> charsets = ((LocalizationSupport)ImageSingletons.lookup(LocalizationSupport.class)).charsets;
        Charset cs = charsets.get(charsetName.toLowerCase(Locale.ROOT));
        if (cs != null) {
            Target_java_nio_charset_Charset.cache(charsetName, cs);
            return cs;
        }
        Target_java_nio_charset_Charset.checkName(charsetName);
        return null;
    }

    @Alias
    private static native void checkName(String var0);

    @Alias
    private static native void cache(String var0, Charset var1);
}

