/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.snippets;

import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.graal.nodes.ReadExceptionObjectNode;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateIntrinsics;
import com.oracle.svm.core.graal.snippets.SubstrateTemplates;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.snippets.ExceptionUnwind;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import java.util.Map;
import jdk.graal.compiler.api.replacements.Snippet;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.UnreachableNode;
import jdk.graal.compiler.nodes.UnwindNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.java.LoadExceptionObjectNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.graal.compiler.replacements.Snippets;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;

public final class ExceptionSnippets
extends SubstrateTemplates
implements Snippets {
    private final SnippetTemplate.SnippetInfo unwind;

    @Snippet
    @NeverInline(value="All methods accessing caller frame must have this annotation. The requirement would not be necessary for a snippet, but the annotation does not matter on the snippet root method, so having the annotation is easier than coding an exception to the annotation checker.")
    protected static void unwindSnippet(Throwable exception, @Snippet.ConstantParameter boolean fromMethodWithCalleeSavedRegisters) {
        Pointer callerSP = KnownIntrinsics.readCallerStackPointer();
        if (fromMethodWithCalleeSavedRegisters) {
            SubstrateIntrinsics.runtimeCall((ForeignCallDescriptor)ExceptionUnwind.UNWIND_EXCEPTION_WITH_CALLEE_SAVED_REGISTERS, exception, callerSP);
        } else {
            SubstrateIntrinsics.runtimeCall((ForeignCallDescriptor)ExceptionUnwind.UNWIND_EXCEPTION_WITHOUT_CALLEE_SAVED_REGISTERS, exception, callerSP);
        }
        throw UnreachableNode.unreachable();
    }

    public static void registerLowerings(OptionValues options, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        new ExceptionSnippets(options, providers, lowerings);
    }

    private ExceptionSnippets(OptionValues options, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        super(options, providers);
        this.unwind = this.snippet(providers, ExceptionSnippets.class, "unwindSnippet", new LocationIdentity[0]);
        lowerings.put(UnwindNode.class, new UnwindLowering());
    }

    protected class UnwindLowering
    implements NodeLoweringProvider<UnwindNode> {
        protected UnwindLowering() {
        }

        @Override
        public void lower(UnwindNode node, LoweringTool tool) {
            if (node.graph().isSubstitution()) {
                return;
            }
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(ExceptionSnippets.this.unwind, node.graph().getGuardsStage(), tool.getLoweringStage());
            args.add("exception", (Object)node.exception());
            args.add("fromMethodWithCalleeSavedRegisters", (Object)((SharedMethod)node.graph().method()).hasCalleeSavedRegisters());
            ExceptionSnippets.this.template((CoreProviders)tool, (ValueNode)node, args).instantiate(tool.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }

    public static class LoadExceptionObjectLowering
    implements NodeLoweringProvider<LoadExceptionObjectNode> {
        @Override
        public void lower(LoadExceptionObjectNode node, LoweringTool tool) {
            StructuredGraph graph = node.graph();
            FixedWithNextNode readRegNode = (FixedWithNextNode)graph.add((Node)new ReadExceptionObjectNode(node.stamp(NodeView.DEFAULT)));
            graph.replaceFixedWithFixed((FixedWithNextNode)node, readRegNode);
        }
    }
}

