/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.configure;

import com.oracle.svm.core.configure.ConfigurationTypeDescriptor;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import jdk.graal.compiler.util.json.JsonWriter;

public record NamedConfigurationTypeDescriptor(String name) implements ConfigurationTypeDescriptor
{
    public NamedConfigurationTypeDescriptor(String name) {
        this.name = ConfigurationTypeDescriptor.checkQualifiedJavaName(name);
    }

    @Override
    public ConfigurationTypeDescriptor.Kind getDescriptorType() {
        return ConfigurationTypeDescriptor.Kind.NAMED;
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public Collection<String> getAllQualifiedJavaNames() {
        return Collections.singleton(this.name);
    }

    @Override
    public int compareTo(ConfigurationTypeDescriptor other) {
        if (other instanceof NamedConfigurationTypeDescriptor) {
            NamedConfigurationTypeDescriptor namedOther = (NamedConfigurationTypeDescriptor)other;
            return this.name.compareTo(namedOther.name);
        }
        return this.getDescriptorType().compareTo(other.getDescriptorType());
    }

    public void printJson(JsonWriter writer) throws IOException {
        writer.quote(this.name);
    }
}

