/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.classinitialization;

import com.oracle.svm.core.classinitialization.TypeReachedProvider;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.StateSplit;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.WithExceptionNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.memory.SingleMemoryKill;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.graal.compiler.nodes.type.StampTool;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.word.LocationIdentity;

@NodeInfo(size=NodeSize.SIZE_16, cycles=NodeCycles.CYCLES_2, cyclesRationale="Class initialization only runs at most once at run time, so the amortized cost is only the is-initialized check")
@Node.NodeIntrinsicFactory
public class EnsureClassInitializedNode
extends WithExceptionNode
implements Canonicalizable,
StateSplit,
SingleMemoryKill,
Lowerable {
    public static final NodeClass<EnsureClassInitializedNode> TYPE = NodeClass.create(EnsureClassInitializedNode.class);
    @Node.Input
    private ValueNode hub;
    @Node.Input(value=InputType.State)
    private FrameState stateAfter;

    public static boolean intrinsify(GraphBuilderContext b, ValueNode hub) {
        b.add((Node)new EnsureClassInitializedNode(b.nullCheckedValue(hub)));
        return true;
    }

    public EnsureClassInitializedNode(ValueNode hub, FrameState stateAfter) {
        super(TYPE, StampFactory.forVoid());
        this.hub = hub;
        assert (StampTool.isPointerNonNull((ValueNode)hub)) : "Hub must already be null-checked";
        this.stateAfter = stateAfter;
    }

    public EnsureClassInitializedNode(ValueNode hub) {
        this(hub, null);
    }

    public ValueNode getHub() {
        return this.hub;
    }

    public LocationIdentity getKilledLocationIdentity() {
        return LocationIdentity.any();
    }

    public FrameState stateAfter() {
        return this.stateAfter;
    }

    public void setStateAfter(FrameState stateAfter) {
        this.updateUsages((Node)this.stateAfter, (Node)stateAfter);
        this.stateAfter = stateAfter;
    }

    public boolean hasSideEffect() {
        return true;
    }

    public ResolvedJavaType constantTypeOrNull(ConstantReflectionProvider constantReflection) {
        if (this.hub.isConstant()) {
            return constantReflection.asJavaType(this.hub.asConstant());
        }
        return null;
    }

    public Node canonical(CanonicalizerTool tool) {
        TypeReachedProvider typeReachedProvider;
        ResolvedJavaType type = this.constantTypeOrNull(tool.getConstantReflection());
        if (type != null && !(typeReachedProvider = (TypeReachedProvider)tool.getConstantReflection()).initializationCheckRequired(type)) {
            for (FrameState cur = this.stateAfter; cur != null; cur = cur.outerFrameState()) {
                if (EnsureClassInitializedNode.needsRuntimeInitialization(cur.getMethod().getDeclaringClass(), type)) continue;
                return null;
            }
        }
        return this;
    }

    public static boolean needsRuntimeInitialization(ResolvedJavaType declaringClass, ResolvedJavaType type) {
        if (type.isInitialized() || type.isArray() || type.equals((Object)declaringClass)) {
            return false;
        }
        if (declaringClass.isInterface()) {
            return true;
        }
        if (type.isAssignableFrom(declaringClass)) {
            if (type.isInterface()) {
                return !type.declaresDefaultMethods();
            }
            return false;
        }
        return true;
    }

    @Node.NodeIntrinsic
    public static native void ensureClassInitialized(Class<?> var0);
}

