/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.foreign;

import com.oracle.svm.core.jdk.NativeLibraries;
import com.oracle.svm.core.jdk.PlatformNativeLibrarySupport;
import java.util.ArrayList;
import java.util.List;
import org.graalvm.word.PointerBase;

final class LookupNativeLibraries
extends NativeLibraries {
    private final List<PlatformNativeLibrarySupport.NativeLibrary> knownLibraries = new ArrayList<PlatformNativeLibrarySupport.NativeLibrary>();

    LookupNativeLibraries() {
    }

    protected boolean addLibrary(String canonical, boolean builtin) {
        PlatformNativeLibrarySupport.NativeLibrary lib = PlatformNativeLibrarySupport.singleton().createLibrary(canonical, builtin);
        if (!lib.load()) {
            return false;
        }
        this.knownLibraries.add(lib);
        return true;
    }

    public PointerBase findSymbol(String name) {
        return LookupNativeLibraries.findSymbol(this.knownLibraries, (String)name);
    }

    public void unloadAllLibraries() {
        for (PlatformNativeLibrarySupport.NativeLibrary known : this.knownLibraries) {
            if (!known.isLoaded() || known.unload()) continue;
            throw new IllegalStateException("Could not unload library: " + known.getCanonicalIdentifier());
        }
        this.knownLibraries.clear();
    }
}

