/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.profiling.framework.collection;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.heap.UnknownObjectField;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.core.annotate.a;
import com.oracle.svm.enterprise.profiling.framework.collection.CodePosition;
import java.util.HashMap;
import java.util.Map;

public class MethodBCITable {
    private static final int INITIAL_METHOD_BCIS_ARRAY_CAPACITY = 32;
    private static final int MAXIMUM_INDEX_SIZE = 0x3FFFFFFF;
    private static final int SMALL_METHOD_ID_BITS = 21;
    private static final int SMALL_BCI_BITS = 10;
    private static final int MAX_SMALL_METHOD_ID = 0x1FFFFF;
    private static final int SMALL_METHOD_ID_MASK = 0x1FFFFF;
    private static final int MAX_SMALL_BCI = 1023;
    private static final int SMALL_BCI_MASK = 1023;
    private static final int SMALL_METHOD_BCI_INDEX_FLAG = Integer.MIN_VALUE;
    private Map<CodePosition, Integer> codePositionLookup = new HashMap<CodePosition, Integer>();
    @a
    @UnknownObjectField(availability=BuildPhaseProvider.CompileQueueFinished.class)
    private int[] methodBCIs = new int[64];

    MethodBCITable() {
    }

    int getOrCreate(CodePosition codePosition) {
        return this.getOrCreate(codePosition.methodID(), codePosition.bci());
    }

    private int getOrCreate(int n2, int n3) {
        assert (n2 >= 0) : "Negative method IDs are not allowed.";
        if (n2 <= 0x1FFFFF && 0 <= n3 && n3 <= 1023) {
            return MethodBCITable.getSmallMethodBCI(n2, n3);
        }
        return this.getOrCreateLargeMethodBCI(n2, n3);
    }

    private static int getSmallMethodBCI(int n2, int n3) {
        return Integer.MIN_VALUE | n2 << 10 | n3;
    }

    private int getOrCreateLargeMethodBCI(int n2, int n3) {
        if (this.codePositionLookup == null) {
            throw VMError.shouldNotReachHere((String)"Cannot add new entries to method-bci table after it was compressed.");
        }
        Integer n4 = this.codePositionLookup.get(new CodePosition(n2, n3));
        if (n4 != null) {
            return n4;
        }
        n4 = this.codePositionLookup.size();
        this.codePositionLookup.put(new CodePosition(n2, n3), n4);
        this.setMethodID(n4, n2);
        this.setBci(n4, n3);
        return n4;
    }

    private void setMethodID(int n2, int n3) {
        this.ensureSize(n2);
        this.methodBCIs[2 * n2] = n3;
    }

    private void setBci(int n2, int n3) {
        this.ensureSize(n2);
        this.methodBCIs[2 * n2 + 1] = n3;
    }

    private void ensureSize(int n2) {
        assert (n2 >= 0);
        int n3 = this.methodBCIs.length / 2;
        if (n2 < n3) {
            return;
        }
        int n4 = n3;
        assert (n4 < 0x3FFFFFFF) : "MethodBCITable requires more capacity than expected.";
        while (n2 >= n4) {
            n4 = (int)Math.min(0x3FFFFFFFL, (long)n4 * 2L);
        }
        int[] nArray = new int[n4 * 2];
        System.arraycopy(this.methodBCIs, 0, nArray, 0, this.methodBCIs.length);
        this.methodBCIs = nArray;
    }

    CodePosition codePosition(int n2) {
        return new CodePosition(this.methodID(n2), this.bci(n2));
    }

    void compress() {
        if (this.codePositionLookup == null) {
            return;
        }
        int n2 = this.codePositionLookup.size();
        int[] nArray = new int[n2 * 2];
        System.arraycopy(this.methodBCIs, 0, nArray, 0, n2 * 2);
        this.methodBCIs = nArray;
        this.codePositionLookup = null;
    }

    int methodID(int n2) {
        if ((n2 & Integer.MIN_VALUE) != 0) {
            return n2 >>> 10 & 0x1FFFFF;
        }
        if (this.codePositionLookup != null && n2 >= this.codePositionLookup.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.methodBCIs[2 * n2];
    }

    int bci(int n2) {
        if ((n2 & Integer.MIN_VALUE) != 0) {
            return n2 & 0x3FF;
        }
        if (this.codePositionLookup != null && n2 >= this.codePositionLookup.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.methodBCIs[2 * n2 + 1];
    }

    void clear() {
        this.codePositionLookup = new HashMap<CodePosition, Integer>();
        this.methodBCIs = new int[64];
    }

    Integer get(CodePosition codePosition) {
        if (this.codePositionLookup == null) {
            throw new IllegalStateException("Cannot use get if MethodBCITable was compressed.");
        }
        if (codePosition.methodID() <= 0x1FFFFF && 0 <= codePosition.bci() && codePosition.bci() <= 1023) {
            return MethodBCITable.getSmallMethodBCI(codePosition.methodID(), codePosition.bci());
        }
        return this.codePositionLookup.get(codePosition);
    }
}

