/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.phases;

import com.oracle.graal.pointsto.flow.AnalysisParsedGraph;
import com.oracle.graal.pointsto.heap.ImageHeapInstance;
import com.oracle.graal.pointsto.heap.ImageHeapObjectArray;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.vector.nodes.simd.u;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.graal.code.CGlobalDataInfo;
import com.oracle.svm.core.graal.code.SubstrateCallingConventionType;
import com.oracle.svm.core.graal.nodes.SubstrateNarrowOopStamp;
import com.oracle.svm.core.graal.stackvalue.StackValueNode;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.core.meta.SubstrateMethodPointerConstant;
import com.oracle.svm.core.meta.SubstrateMethodPointerStamp;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.threadlocal.VMThreadLocalInfo;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.hosted.cai.e;
import com.oracle.svm.hosted.meta.HostedElement;
import com.oracle.svm.hosted.meta.HostedMethod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import jdk.graal.compiler.bytecode.ResolvedJavaMethodBytecode;
import jdk.graal.compiler.core.common.CompilationIdentifier;
import jdk.graal.compiler.core.common.CompressEncoding;
import jdk.graal.compiler.core.common.type.ArithmeticStamp;
import jdk.graal.compiler.core.common.type.FloatStamp;
import jdk.graal.compiler.core.common.type.IllegalStamp;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.ObjectStamp;
import jdk.graal.compiler.core.common.type.RawPointerStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampPair;
import jdk.graal.compiler.core.common.type.VoidStamp;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.graal.compiler.hotspot.nodes.type.HotSpotNarrowOopStamp;
import jdk.graal.compiler.hotspot.nodes.type.KlassPointerStamp;
import jdk.graal.compiler.hotspot.nodes.type.MethodCountersPointerStamp;
import jdk.graal.compiler.hotspot.nodes.type.MethodPointerStamp;
import jdk.graal.compiler.nodes.EncodedGraph;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.GraphDecoder;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.ProfileData;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.calc.IntegerBelowNode;
import jdk.graal.compiler.nodes.calc.IntegerLessThanNode;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.phases.BasePhase;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaMethodProfile;
import jdk.vm.ci.meta.JavaTypeProfile;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.word.LocationIdentity;

public class HotMethodDuplicationPhase<C>
extends BasePhase<C> {
    private static final AtomicInteger uy = new AtomicInteger();
    private final double uz;
    private final Function<HostedMethod, e.a> uA;

    public HotMethodDuplicationPhase(Function<HostedMethod, e.a> function, double d2) {
        this.uA = function;
        this.uz = d2;
    }

    protected void run(StructuredGraph structuredGraph, C c2) {
        assert (structuredGraph.globalProfileProvider().hotCaller()) : "Should not run on cold compilation units";
        if (!((Boolean)c.uK.getValue(structuredGraph.getOptions())).booleanValue()) {
            return;
        }
        b b2 = new b(structuredGraph);
        e.a a2 = this.uA.apply((HostedMethod)structuredGraph.method());
        HotMethodDuplicationPhase.a(structuredGraph, invoke -> {
            HostedMethod hostedMethod;
            NodeSourcePosition nodeSourcePosition = FrameState.toSourcePosition((FrameState)invoke.stateDuring());
            e.a a3 = a2.a((BytecodePosition)nodeSourcePosition, (ResolvedJavaMethod)(hostedMethod = (HostedMethod)invoke.getTargetMethod()));
            if (a3 == null) {
                HotMethodDuplicationPhase.a(b2, hostedMethod, "No context", invoke.asNode().getNodeSourcePosition().getBCI());
                return;
            }
            if (!a3.a(this.uz)) {
                HotMethodDuplicationPhase.a(b2, hostedMethod, "Cold " + a3.eD(), invoke.asNode().getNodeSourcePosition().getBCI());
                return;
            }
            HostedMethod hostedMethod2 = HotMethodDuplicationPhase.a(b2, (BytecodePosition)nodeSourcePosition, hostedMethod, a3, invoke);
            assert (invoke.callTarget() != null);
            invoke.callTarget().setTargetMethod((ResolvedJavaMethod)hostedMethod2);
        });
    }

    private static HostedMethod a(b b2, BytecodePosition bytecodePosition, HostedMethod hostedMethod, e.a a2, Invoke invoke) {
        HostedMethod hostedMethod2;
        if (((Boolean)c.uM.getValue(b2.uC.getOptions())).booleanValue() && a2.eC() && (hostedMethod2 = a2.h(hostedMethod)) != null) {
            HotMethodDuplicationPhase.a(b2, hostedMethod2, "Reusing", invoke.asNode().getNodeSourcePosition().getBCI());
            return hostedMethod2;
        }
        hostedMethod2 = b2.a(hostedMethod, bytecodePosition);
        HotMethodDuplicationPhase.a(b2, hostedMethod2, "Duplicated", invoke.asNode().getNodeSourcePosition().getBCI());
        return hostedMethod2;
    }

    private static void a(b b2, HostedMethod hostedMethod, String string, int n2) {
        if (((Boolean)c.uL.getValue(b2.uC.getOptions())).booleanValue()) {
            ResolvedJavaMethod resolvedJavaMethod = b2.uC.method();
            b2.uC.getDebug().log("[HotMethodDuplicationPhase] %-10s: %-30s called from %s at %d", (Object)string, (Object)hostedMethod.format("%h.%n"), (Object)resolvedJavaMethod.format("%h.%n"), (Object)n2);
        }
    }

    private static void a(StructuredGraph structuredGraph, Consumer<Invoke> consumer) {
        for (Node node : structuredGraph.getNodes()) {
            Invoke invoke;
            if (!(node instanceof Invoke) || !(invoke = (Invoke)node).getInvokeKind().isDirect() || invoke.getTargetMethod() == null) continue;
            consumer.accept(invoke);
        }
    }

    public static class c {
        public static final OptionKey<Boolean> uK = new OptionKey((Object)true);
        public static final OptionKey<Boolean> uL = new OptionKey((Object)false);
        public static final OptionKey<Boolean> uM = new OptionKey((Object)true);
    }

    private static final class b {
        private final StructuredGraph uC;
        private final Map<a, HostedMethod> uD = new HashMap<a, HostedMethod>();
        private HostedMethod uE;
        private HostedMethod uF;
        private Map<Object, Object> uG;
        private static final Class<?>[] uH = new Class[]{ImageHeapInstance.class, ImageHeapObjectArray.class, SubstrateCallingConventionType.class, StackValueNode.StackSlotIdentity.class, SnippetRuntime.SubstrateForeignCallDescriptor.class, VMThreadLocalInfo.class, Boolean.class, Integer.class, String.class, CompressEncoding.class, ProfileData.BranchProbabilityData.class, ProfileData.SwitchProbabilityData.class, IntegerBelowNode.BelowOp.class, IntegerLessThanNode.LessThanOp.class, Register.class, JavaMethodProfile.class, JavaTypeProfile.class};

        private b(StructuredGraph structuredGraph) {
            this.uC = structuredGraph;
        }

        private HostedMethod a(HostedMethod hostedMethod, BytecodePosition bytecodePosition) {
            return this.uD.computeIfAbsent(new a(bytecodePosition, hostedMethod.wrapped), a2 -> this.v(hostedMethod));
        }

        private HostedMethod v(HostedMethod hostedMethod) {
            this.uE = hostedMethod;
            this.uF = hostedMethod.getOrCreateMultiMethod((MultiMethod.MultiMethodKey)new com.oracle.svm.enterprise.hosted.phases.HotMethodDuplicationPhase$a());
            this.uG = new IdentityHashMap<Object, Object>();
            EncodedGraph encodedGraph = this.a(hostedMethod.compilationInfo.getCompilationGraph().getEncodedGraph());
            this.uF.compilationInfo.encodeGraph(this.a(encodedGraph, (ResolvedJavaMethod)this.uF));
            return this.uF;
        }

        private EncodedGraph a(EncodedGraph encodedGraph) {
            Object[] objectArray = encodedGraph.getObjects();
            Object[] objectArray2 = new Object[objectArray.length];
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                objectArray2[i2] = this.o(objectArray[i2]);
            }
            return new EncodedGraph(Arrays.copyOf(encodedGraph.getEncoding(), encodedGraph.getEncoding().length), encodedGraph.getStartOffset(), objectArray2, Arrays.copyOf(encodedGraph.getNodeClasses(), encodedGraph.getNodeClasses().length), encodedGraph.getAssumptions(), encodedGraph.getInlinedMethods(), encodedGraph.hasUnsafeAccess(), encodedGraph.trackNodeSourcePosition());
        }

        private StructuredGraph a(EncodedGraph encodedGraph, ResolvedJavaMethod resolvedJavaMethod) {
            DebugContext debugContext = this.uC.getDebug();
            StructuredGraph structuredGraph = new StructuredGraph.Builder(this.uC.getOptions(), debugContext).method(resolvedJavaMethod).recordInlinedMethods(encodedGraph.isRecordingInlinedMethods()).trackNodeSourcePosition(encodedGraph.trackNodeSourcePosition()).compilationId((CompilationIdentifier)CompilationIdentifier.INVALID_COMPILATION_ID).build();
            try (DebugContext.Scope scope = debugContext.scope((Object)"HotMethodDuplicationPhase#decodeGraph", (Object)structuredGraph, (Object)resolvedJavaMethod);){
                new GraphDecoder(AnalysisParsedGraph.HOST_ARCHITECTURE, structuredGraph).decode(encodedGraph);
            }
            catch (Throwable throwable) {
                throw debugContext.handle(throwable);
            }
            assert (structuredGraph.verify());
            return structuredGraph;
        }

        private Object o(Object object) {
            if (object == null) {
                return null;
            }
            return this.uG.computeIfAbsent(object, this::p);
        }

        private ResolvedJavaMethod c(ResolvedJavaMethod resolvedJavaMethod) {
            if (Objects.equals(resolvedJavaMethod, this.uE)) {
                return this.uF;
            }
            return (ResolvedJavaMethod)this.o(resolvedJavaMethod);
        }

        private Object p(Object object) {
            assert (object != null) : "newReplacement assumes obj is not null";
            if (object instanceof Node) {
                throw VMError.shouldNotReachHere((String)"Must not replace a Graal graph nodes, only data objects referenced from a node");
            }
            if (object.getClass() == ResolvedJavaMethodBytecode.class) {
                ResolvedJavaMethodBytecode resolvedJavaMethodBytecode = (ResolvedJavaMethodBytecode)object;
                HostedMethod hostedMethod = (HostedMethod)this.o(resolvedJavaMethodBytecode.getMethod());
                return new ResolvedJavaMethodBytecode(this.c((ResolvedJavaMethod)hostedMethod), resolvedJavaMethodBytecode.getOrigin());
            }
            if (object.getClass() == SubstrateMethodPointerConstant.class) {
                SubstrateMethodPointerConstant substrateMethodPointerConstant = (SubstrateMethodPointerConstant)object;
                MethodPointer methodPointer = substrateMethodPointerConstant.pointer();
                ResolvedJavaMethod resolvedJavaMethod = methodPointer.getMethod();
                ResolvedJavaMethod resolvedJavaMethod2 = this.c(resolvedJavaMethod);
                return new SubstrateMethodPointerConstant(new MethodPointer(resolvedJavaMethod2));
            }
            if (object.getClass() == NodeSourcePosition.class) {
                NodeSourcePosition nodeSourcePosition = (NodeSourcePosition)object;
                NodeSourcePosition nodeSourcePosition2 = (NodeSourcePosition)this.o(nodeSourcePosition.getCaller());
                ResolvedJavaMethod resolvedJavaMethod = this.c(nodeSourcePosition.getMethod());
                return new NodeSourcePosition(nodeSourcePosition.getSourceLanguage(), nodeSourcePosition2, resolvedJavaMethod, nodeSourcePosition.getBCI(), nodeSourcePosition.getMarker());
            }
            if (object instanceof Stamp) {
                return this.s(object);
            }
            if (object.getClass() == StampPair.class) {
                StampPair stampPair = (StampPair)object;
                return StampPair.create((Stamp)((Stamp)this.o(stampPair.getTrustedStamp())), (Stamp)((Stamp)this.o(stampPair.getUncheckedStamp())));
            }
            if (object.getClass() == ArrayList.class) {
                ArrayList arrayList = (ArrayList)object;
                ArrayList<Object> arrayList2 = new ArrayList<Object>(arrayList.size());
                for (Object e2 : arrayList) {
                    arrayList2.add(this.o(e2));
                }
                return arrayList2;
            }
            if (object instanceof EnumSet) {
                EnumSet enumSet = (EnumSet)object;
                return EnumSet.copyOf(enumSet);
            }
            if (object.getClass() == CGlobalDataInfo.class) {
                return object;
            }
            Cloneable cloneable = this.q(object);
            if (cloneable != null) {
                return cloneable;
            }
            if (b.r(object)) {
                return object;
            }
            assert (false) : "Unknown Type detected during duplication: " + String.valueOf(object.getClass());
            return object;
        }

        private Cloneable q(Object object) {
            if (object instanceof short[]) {
                short[] sArray = (short[])object;
                return Arrays.copyOf(sArray, sArray.length);
            }
            if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                return Arrays.copyOf(byArray, byArray.length);
            }
            if (object instanceof int[]) {
                int[] nArray = (int[])object;
                return Arrays.copyOf(nArray, nArray.length);
            }
            if (object instanceof long[]) {
                long[] lArray = (long[])object;
                return Arrays.copyOf(lArray, lArray.length);
            }
            if (object instanceof char[]) {
                char[] cArray = (char[])object;
                return Arrays.copyOf(cArray, cArray.length);
            }
            if (object instanceof float[]) {
                float[] fArray = (float[])object;
                return Arrays.copyOf(fArray, fArray.length);
            }
            if (object instanceof double[]) {
                double[] dArray = (double[])object;
                return Arrays.copyOf(dArray, dArray.length);
            }
            if (object instanceof boolean[]) {
                boolean[] blArray = (boolean[])object;
                return Arrays.copyOf(blArray, blArray.length);
            }
            if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                Object[] objectArray2 = Arrays.copyOf(objectArray, objectArray.length);
                for (int i2 = 0; i2 < objectArray2.length; ++i2) {
                    objectArray2[i2] = this.o(objectArray2[i2]);
                }
                return objectArray2;
            }
            return null;
        }

        private static boolean r(Object object) {
            if (object instanceof Enum) {
                return true;
            }
            if (object instanceof LocationIdentity) {
                return true;
            }
            if (object instanceof JavaConstant) {
                return true;
            }
            if (object instanceof HostedElement) {
                return true;
            }
            return Arrays.stream(uH).anyMatch(clazz -> object.getClass() == clazz);
        }

        private Object s(Object object) {
            if (object instanceof ArithmeticStamp) {
                if (object.getClass() == u.class) {
                    u u2 = (u)object;
                    Stamp[] stampArray = new Stamp[u2.jW()];
                    for (int i2 = 0; i2 < u2.jW(); ++i2) {
                        stampArray[i2] = u2.L(i2);
                    }
                    return new u(stampArray);
                }
                if (object.getClass() == IntegerStamp.class) {
                    IntegerStamp integerStamp = (IntegerStamp)object;
                    return IntegerStamp.create((int)integerStamp.getBits(), (long)integerStamp.lowerBound(), (long)integerStamp.upperBound());
                }
                if (object.getClass() == FloatStamp.class) {
                    FloatStamp floatStamp = (FloatStamp)object;
                    return FloatStamp.create((int)floatStamp.getBits(), (double)floatStamp.lowerBound(), (double)floatStamp.upperBound(), (boolean)floatStamp.isNonNaN());
                }
                assert (false) : "Unknown Stamp Type during method duplication - subclass of ArithmeticStamp";
            }
            if (object.getClass() == IllegalStamp.class || object.getClass() == VoidStamp.class || object.getClass() == RawPointerStamp.class || object.getClass() == SubstrateMethodPointerStamp.class || object.getClass() == MethodPointerStamp.class || object.getClass() == KlassPointerStamp.class || object.getClass() == MethodCountersPointerStamp.class || object.getClass() == SubstrateNarrowOopStamp.class || object.getClass() == ObjectStamp.class || object.getClass() == PiNode.PlaceholderStamp.class) {
                return object;
            }
            if (object.getClass() == HotSpotNarrowOopStamp.class) assert (false) : "HotSpotNarrowOopStamp found while duplicating method for Substrate use.";
            if (object.getClass() == com.oracle.graal.vector.nodes.type.a.class) {
                com.oracle.graal.vector.nodes.type.a a2 = (com.oracle.graal.vector.nodes.type.a)object;
                return new com.oracle.graal.vector.nodes.type.a((Stamp)this.o(a2.it()));
            }
            if (object.getClass() == com.oracle.graal.vector.nodes.simd.b.class) {
                return object;
            }
            assert (false) : "Unknown Stamp Type during method duplication: " + String.valueOf(object) + " of class " + String.valueOf(object.getClass());
            return object;
        }

        private static final class a {
            final BytecodePosition uI;
            final AnalysisMethod uJ;

            a(BytecodePosition bytecodePosition, AnalysisMethod analysisMethod) {
                this.uI = bytecodePosition;
                this.uJ = analysisMethod;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                a a2 = (a)object;
                return Objects.equals(this.uI, a2.uI) && Objects.equals(this.uJ, a2.uJ);
            }

            public int hashCode() {
                return Objects.hash(this.uI, this.uJ);
            }
        }
    }

    private static final class a
    implements MultiMethod.MultiMethodKey {
        final int uB = uy.getAndIncrement();

        private a() {
        }

        public String toString() {
            return "H" + this.uB;
        }
    }
}

