/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.pgo.phases;

import com.oracle.graal.pointsto.infrastructure.Universe;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.nodes.SubstrateMethodCallTargetNode;
import com.oracle.svm.enterprise.hosted.cai.e;
import com.oracle.svm.enterprise.hosted.pgo.b;
import com.oracle.svm.enterprise.hosted.pgo.features.PGOFeature;
import com.oracle.svm.enterprise.hosted.pgo.profiles.PGOProfilesLookup;
import com.oracle.svm.enterprise.profiling.metadata.codepositions.ProfilingHostedCodePosition;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedUniverse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.ControlSplitNode;
import jdk.graal.compiler.nodes.IndirectCallTargetNode;
import jdk.graal.compiler.nodes.ProfileData;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.java.MethodCallTargetNode;
import jdk.graal.compiler.phases.SingleRunSubphase;
import jdk.graal.compiler.phases.tiers.HighTierContext;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.meta.JavaMethodProfile;
import jdk.vm.ci.meta.JavaTypeProfile;
import org.graalvm.collections.EconomicMap;

public final class PGOApplyProfilesPhase
extends SingleRunSubphase<HighTierContext> {
    private final PGOProfilesLookup pgoProfiles;
    private final List<ProfilingHostedCodePosition> inliningContext;
    private final HostedUniverse hUniverse;
    private final e.a compilationRootContext;
    private final boolean forceHot;
    private final a.a profileQualityLevel;

    public static PGOApplyProfilesPhase createForExpandingHotCutoffs(List<ProfilingHostedCodePosition> list, HostedUniverse hostedUniverse, e.a a2, PGOProfilesLookup pGOProfilesLookup) {
        return new PGOApplyProfilesPhase(list, hostedUniverse, a2, pGOProfilesLookup, true, a.a.tT);
    }

    public static PGOApplyProfilesPhase createForExpandingCutoffs(List<ProfilingHostedCodePosition> list, HostedUniverse hostedUniverse, PGOProfilesLookup pGOProfilesLookup) {
        return new PGOApplyProfilesPhase(list, hostedUniverse, null, pGOProfilesLookup, false, a.a.tT);
    }

    public static PGOApplyProfilesPhase createForBeforeHotCompilationPhase(HostedUniverse hostedUniverse, e.a a2, PGOProfilesLookup pGOProfilesLookup) {
        return new PGOApplyProfilesPhase(Collections.emptyList(), hostedUniverse, a2, pGOProfilesLookup, false, a.a.tT);
    }

    public static PGOApplyProfilesPhase createContextInsensitive(HostedUniverse hostedUniverse, PGOProfilesLookup pGOProfilesLookup) {
        a.a a2 = a.a.tT;
        if (((Boolean)PGOFeature.a.PGOPrintProfileQuality.getValue()).booleanValue()) {
            a2 = a.a.tU;
            if (((Boolean)PGOFeature.a.PGOPrintProfileQualityDetails.getValue()).booleanValue()) {
                a2 = a.a.tV;
            }
        }
        return new PGOApplyProfilesPhase(Collections.emptyList(), hostedUniverse, null, pGOProfilesLookup, false, a2);
    }

    private PGOApplyProfilesPhase(List<ProfilingHostedCodePosition> list, HostedUniverse hostedUniverse, e.a a2, PGOProfilesLookup pGOProfilesLookup, boolean bl2, a.a a3) {
        this.pgoProfiles = pGOProfilesLookup;
        this.inliningContext = list;
        this.hUniverse = hostedUniverse;
        this.compilationRootContext = a2;
        this.forceHot = bl2;
        this.profileQualityLevel = a3;
    }

    protected void run(StructuredGraph structuredGraph, HighTierContext highTierContext) {
        this.incrementMethodCounter();
        this.updateProfilesForInvokes(structuredGraph);
        this.updateProfilesForConditionals(structuredGraph);
    }

    private void incrementMethodCounter() {
        if (this.profileQualityLevel.a(a.a.tU)) {
            a.tR.incrementAndGet();
        }
    }

    private void updateProfilesForConditionals(StructuredGraph structuredGraph) {
        PGOApplyProfilesPhase.forEachRelevantControlSplitNode(structuredGraph, this::updateConditionalProbabilitiesBasedOnSamples);
        PGOApplyProfilesPhase.forEachRelevantControlSplitNode(structuredGraph, this::updateConditionalProbabilities);
    }

    private void updateProfilesForInvokes(StructuredGraph structuredGraph) {
        Consumer<MethodCallTargetNode> consumer = this.forceHot || structuredGraph.globalProfileProvider().hotCaller() ? this::updateInvokeProfileForHotCaller : this::updateInvokeProfileForColdCompilationUnit;
        PGOApplyProfilesPhase.forEachIndirectInvoke(structuredGraph, consumer);
    }

    private void updateInvokeProfileForColdCompilationUnit(MethodCallTargetNode methodCallTargetNode) {
        this.updateInvokesWithNewProfiles(methodCallTargetNode);
    }

    private static void forEachIndirectInvoke(StructuredGraph structuredGraph, Consumer<MethodCallTargetNode> consumer) {
        List list = structuredGraph.getNodes(MethodCallTargetNode.TYPE).snapshot();
        for (MethodCallTargetNode methodCallTargetNode : list) {
            if (!methodCallTargetNode.invokeKind().isIndirect()) continue;
            consumer.accept(methodCallTargetNode);
        }
    }

    private void updateInvokeProfileForHotCaller(MethodCallTargetNode methodCallTargetNode) {
        this.updateInvokeProfileForColdCompilationUnit(methodCallTargetNode);
        if (this.compilationRootContext == null) {
            return;
        }
        JavaMethodProfile javaMethodProfile = PGOApplyProfilesPhase.validateProfile((CallTargetNode)methodCallTargetNode, this.compilationRootContext.a(this.hUniverse, (BytecodePosition)methodCallTargetNode.getNodeSourcePosition()));
        if (javaMethodProfile != null) {
            ((SubstrateMethodCallTargetNode)methodCallTargetNode).setJavaMethodProfile(javaMethodProfile);
        }
    }

    public static JavaMethodProfile validateProfile(CallTargetNode callTargetNode, JavaMethodProfile javaMethodProfile) {
        if (javaMethodProfile == null || callTargetNode == null || callTargetNode.targetMethod() == null) {
            return callTargetNode instanceof IndirectCallTargetNode ? javaMethodProfile : null;
        }
        ArrayList<JavaMethodProfile.ProfiledMethod> arrayList = new ArrayList<JavaMethodProfile.ProfiledMethod>();
        double d2 = javaMethodProfile.getNotRecordedProbability();
        boolean bl2 = true;
        HostedMethod hostedMethod = (HostedMethod)callTargetNode.targetMethod();
        HashSet<HostedMethod> hashSet = new HashSet<HostedMethod>(Arrays.asList(hostedMethod.getImplementations()));
        hashSet.add(hostedMethod);
        for (JavaMethodProfile.ProfiledMethod profiledMethod : javaMethodProfile.getMethods()) {
            if (hashSet.contains(profiledMethod.getMethod())) {
                arrayList.add(profiledMethod);
                continue;
            }
            bl2 = false;
            d2 += profiledMethod.getProbability();
        }
        return bl2 ? javaMethodProfile : new JavaMethodProfile(d2, arrayList.toArray(new JavaMethodProfile.ProfiledMethod[0]));
    }

    private void updateInvokesWithNewProfiles(MethodCallTargetNode methodCallTargetNode) {
        List<ProfilingHostedCodePosition> list = PGOApplyProfilesPhase.createPointContext(methodCallTargetNode.getNodeSourcePosition(), this.inliningContext);
        Optional<Map<AnalysisType, Long>> optional = this.pgoProfiles.getVirtualInvokeProfile(list);
        if (optional.isPresent()) {
            SubstrateMethodCallTargetNode substrateMethodCallTargetNode = (SubstrateMethodCallTargetNode)methodCallTargetNode;
            JavaTypeProfile javaTypeProfile = b.a(substrateMethodCallTargetNode.getTypeProfile(), optional, (Universe)this.hUniverse);
            JavaMethodProfile javaMethodProfile = b.a(substrateMethodCallTargetNode.getMethodProfile(), javaTypeProfile);
            substrateMethodCallTargetNode.setProfiles(javaTypeProfile, javaMethodProfile);
            this.countSuccess();
        } else {
            this.countFailure(list);
        }
    }

    private void countSuccess() {
        if (this.profileQualityLevel.a(a.a.tU)) {
            a.tN.incrementAndGet();
        }
    }

    private void countFailure(List<ProfilingHostedCodePosition> list) {
        if (this.profileQualityLevel.a(a.a.tU)) {
            a.tO.incrementAndGet();
            if (this.profileQualityLevel.a(a.a.tV)) {
                a.tS.add(list);
            }
        }
    }

    private static void forEachRelevantControlSplitNode(StructuredGraph structuredGraph, Consumer<ControlSplitNode> consumer) {
        EconomicMap<NodeSourcePosition, List<ControlSplitNode>> economicMap = com.oracle.svm.enterprise.hosted.profiling.utilities.a.j(structuredGraph);
        for (List list : economicMap.getValues()) {
            for (ControlSplitNode controlSplitNode : list) {
                consumer.accept(controlSplitNode);
            }
        }
    }

    private void updateConditionalProbabilitiesBasedOnSamples(ControlSplitNode controlSplitNode) {
    }

    private void updateConditionalProbabilities(ControlSplitNode controlSplitNode) {
        List<ProfilingHostedCodePosition> list = PGOApplyProfilesPhase.createPointContext(controlSplitNode.getNodeSourcePosition(), this.inliningContext);
        Optional<PGOProfilesLookup.ProfiledValue<long[]>> optional = this.pgoProfiles.getConditionalProfile(list);
        optional.ifPresentOrElse(profiledValue -> {
            PGOApplyProfilesPhase.setSuccessorsProbabilities(profiledValue.source(), (long[])profiledValue.value(), controlSplitNode);
            this.countSuccess();
        }, () -> this.countFailure(list));
    }

    private static void setSuccessorsProbabilities(ProfileData.ProfileSource profileSource, long[] lArray, ControlSplitNode controlSplitNode) {
        List list = controlSplitNode.successors().snapshot();
        List<Node> list2 = list.stream().filter(Node::isAlive).collect(Collectors.toList());
        Optional<Map<Integer, Double>> optional = PGOApplyProfilesPhase.aggregatedProbabilities(lArray);
        if (optional.isEmpty()) {
            return;
        }
        List<Node> list3 = PGOApplyProfilesPhase.successorsMatchingProfiles(list2, optional.get());
        list3.forEach(node -> controlSplitNode.setProbability((AbstractBeginNode)node, ProfileData.BranchProbabilityData.create((double)((Double)((Map)optional.get()).get(node.getNodeSourcePosition().getBCI())), (ProfileData.ProfileSource)profileSource)));
    }

    public static Optional<Map<Integer, Double>> aggregatedProbabilities(long[] lArray) {
        int[] nArray = com.oracle.svm.enterprise.profiling.kinds.a.d(lArray);
        int[] nArray2 = com.oracle.svm.enterprise.profiling.kinds.a.e(lArray);
        Optional<double[]> optional = com.oracle.svm.enterprise.profiling.kinds.a.f(lArray);
        if (optional.isEmpty()) {
            return Optional.empty();
        }
        HashMap<Integer, Double> hashMap = new HashMap<Integer, Double>();
        for (int i2 = 0; i2 < nArray2.length; ++i2) {
            if (hashMap.containsKey(nArray2[i2])) {
                hashMap.put(nArray2[i2], (Double)hashMap.get(nArray2[i2]) + optional.get()[i2]);
                continue;
            }
            hashMap.put(nArray2[i2], optional.get()[i2]);
        }
        HashMap<Integer, Double> hashMap2 = new HashMap<Integer, Double>();
        for (int i3 = 0; i3 < nArray.length; ++i3) {
            if (!com.oracle.svm.enterprise.profiling.kinds.a.l(nArray[i3])) continue;
            hashMap2.put(nArray[i3], (Double)hashMap.get(nArray2[i3]));
        }
        return Optional.of(hashMap2);
    }

    public static List<Node> successorsMatchingProfiles(List<Node> list, Map<Integer, Double> map) {
        return list.stream().filter(node -> map.containsKey(node.getNodeSourcePosition().getBCI())).collect(Collectors.toList());
    }

    public static List<ProfilingHostedCodePosition> createPointContext(NodeSourcePosition nodeSourcePosition, List<ProfilingHostedCodePosition> list) {
        ArrayList arrayList = (ArrayList)PGOApplyProfilesPhase.createContextFromNodeSourcePosition(nodeSourcePosition);
        arrayList.addAll(list);
        return arrayList;
    }

    public static List<ProfilingHostedCodePosition> createContextFromNodeSourcePosition(NodeSourcePosition nodeSourcePosition2) {
        return StreamSupport.stream(nodeSourcePosition2.spliterator(), false).map(nodeSourcePosition -> new ProfilingHostedCodePosition(((HostedMethod)nodeSourcePosition.getMethod()).getWrapped(), nodeSourcePosition.getBCI())).collect(Collectors.toList());
    }

    public static final class com.oracle.svm.enterprise.hosted.pgo.phases.PGOApplyProfilesPhase$a {
        private static final AtomicLong tN = new AtomicLong();
        private static final AtomicLong tO = new AtomicLong();
        private static final AtomicLong tP = new AtomicLong();
        private static final AtomicLong tQ = new AtomicLong();
        private static final AtomicLong tR = new AtomicLong();
        private static final List<List<ProfilingHostedCodePosition>> tS = Collections.synchronizedList(new ArrayList());

        private com.oracle.svm.enterprise.hosted.pgo.phases.PGOApplyProfilesPhase$a() {
        }

        public static long gb() {
            return tN.get();
        }

        public static long gd() {
            return tO.get();
        }

        public static long ge() {
            return tR.get();
        }

        public static List<List<ProfilingHostedCodePosition>> gf() {
            return Collections.unmodifiableList(tS);
        }

        public static double gg() {
            long l2;
            long l3 = com.oracle.svm.enterprise.hosted.pgo.phases.PGOApplyProfilesPhase$a.gb();
            long l4 = l3 + (l2 = com.oracle.svm.enterprise.hosted.pgo.phases.PGOApplyProfilesPhase$a.gd());
            return l4 == 0L ? 0.0 : 100.0 * (double)l3 / (double)l4;
        }

        public static double gh() {
            long l2 = tP.get();
            long l3 = tQ.get();
            return l2 == 0L ? 0.0 : 100.0 * (double)l3 / (double)l2;
        }

        public static void a(long l2, long l3) {
            tP.addAndGet(l3);
            tQ.addAndGet(l2);
        }

        static final class a
        extends Enum<a> {
            public static final /* enum */ a tT = new a();
            public static final /* enum */ a tU = new a();
            public static final /* enum */ a tV = new a();
            private static final /* synthetic */ a[] $VALUES;

            public static a[] values() {
                return (a[])$VALUES.clone();
            }

            public static a L(String string) {
                return Enum.valueOf(a.class, string);
            }

            boolean a(a a2) {
                return this.ordinal() >= a2.ordinal();
            }

            private static /* synthetic */ a[] gi() {
                return new a[]{tT, tU, tV};
            }

            static {
                $VALUES = a.gi();
            }
        }
    }
}

