/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.cai;

import com.oracle.graal.compiler.enterprise.EnterpriseHighTier;
import com.oracle.graal.duplication.phases.PullThroughPhiPhase;
import com.oracle.graal.phases.preciseinline.priorityinline.PriorityInliningPhase;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.enterprise.core.bc;
import com.oracle.svm.enterprise.hosted.cai.d;
import com.oracle.svm.enterprise.hosted.cai.e;
import com.oracle.svm.enterprise.hosted.code.layout.CalculateCallEdgeCountPhase;
import com.oracle.svm.enterprise.hosted.code.layout.CalculateCallEdgeInfoPhase;
import com.oracle.svm.enterprise.hosted.pgo.features.PGOFeature;
import com.oracle.svm.enterprise.hosted.pgo.profiles.PGOProfilesLookup;
import com.oracle.svm.enterprise.hosted.phases.BeforeHotCallerCompilationPhase;
import com.oracle.svm.enterprise.hosted.phases.HotMethodDuplicationPhase;
import com.oracle.svm.enterprise.hosted.phases.priorityinline.SubstratePriorityInliningPhase;
import com.oracle.svm.enterprise.hosted.phases.priorityinline.h;
import com.oracle.svm.hosted.FeatureHandler;
import com.oracle.svm.hosted.NativeImageGenerator;
import com.oracle.svm.hosted.code.CompileQueue;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.pltgot.PLTGOTOptions;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import jdk.graal.compiler.code.CompilationResult;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.loop.DefaultLoopPolicies;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.PhaseSuite;
import jdk.graal.compiler.phases.common.HighTierLoweringPhase;
import jdk.graal.compiler.phases.tiers.LowTierContext;
import jdk.graal.compiler.phases.tiers.Suites;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.code.site.Call;
import jdk.vm.ci.code.site.Infopoint;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.nativeimage.ImageSingletons;

public final class a
extends com.oracle.svm.enterprise.hosted.code.a {
    private static final String qI = "%H.%n";
    private static final String qJ = "CAICompileQueue";
    private final e qK;
    private final ConcurrentMap<HostedMethod, e.a> qL = new ConcurrentHashMap<HostedMethod, e.a>();
    private final PGOProfilesLookup qM;
    private final Map<HostedMethod, Set<CompileQueue.CompileReason>> qN = new ConcurrentHashMap<HostedMethod, Set<CompileQueue.CompileReason>>();
    private final DebugContext qO;
    private final double qP;
    private boolean qQ;
    private Suites qR;

    public a(DebugContext debugContext, FeatureHandler featureHandler, HostedUniverse hostedUniverse, RuntimeConfiguration runtimeConfiguration, Boolean bl2, PGOProfilesLookup pGOProfilesLookup, List<CompileQueue.Policy> list) {
        super(debugContext, featureHandler, hostedUniverse, runtimeConfiguration, bl2, list);
        this.qM = pGOProfilesLookup;
        this.qK = new e(pGOProfilesLookup);
        this.qO = debugContext;
        this.qP = (Double)com.oracle.svm.enterprise.hosted.cai.b.CAIHotContextsRatio.getValue(debugContext.getOptions());
        ImageSingletons.add(e.class, (Object)this.qK);
        this.eq();
    }

    private void eq() {
        try (DebugContext.Scope scope = this.qO.scope((Object)qJ);){
            if (this.qK.eA().isEmpty()) {
                this.qO.log("[%s] No entry points in prefix tree.%n", (Object)qJ);
            }
            for (AnalysisMethod analysisMethod : this.qK.eA().keySet()) {
                this.qO.log("[%s] Prefix Tree Entry Point: %s.%n", (Object)qJ, (Object)analysisMethod.format(qI));
            }
        }
    }

    @Override
    protected OptionValues getCustomizedOptions(HostedMethod hostedMethod, DebugContext debugContext) {
        OptionValues optionValues = super.getCustomizedOptions(hostedMethod, debugContext);
        if (this.b(hostedMethod, debugContext.getOptions())) {
            return a.b(optionValues);
        }
        if (!this.qL.containsKey(hostedMethod)) {
            return optionValues;
        }
        UnmodifiableEconomicMap unmodifiableEconomicMap = optionValues.getMap();
        EconomicMap economicMap = OptionValues.newOptionMap();
        economicMap.putAll(unmodifiableEconomicMap);
        if (((Boolean)com.oracle.svm.enterprise.hosted.cai.b.qV.getValue(optionValues)).booleanValue()) {
            economicMap.put((Object)PriorityInliningPhase.b.zn, com.oracle.svm.enterprise.hosted.cai.b.HotCompilationBaseTargetSpending.getValue());
            economicMap.put((Object)PriorityInliningPhase.b.yU, com.oracle.svm.enterprise.hosted.cai.b.HotCompilationCompilerNodePenaltyCoefficient.getValue());
            economicMap.put((Object)PriorityInliningPhase.b.yT, com.oracle.svm.enterprise.hosted.cai.b.HotCompilationCutoffCodeSizePenaltyCoefficient.getValue());
            economicMap.put((Object)PriorityInliningPhase.b.ze, com.oracle.svm.enterprise.hosted.cai.b.HotCompilationExpansionInertiaBaseValue.getValue());
            economicMap.put((Object)PriorityInliningPhase.b.za, com.oracle.svm.enterprise.hosted.cai.b.HotCompilationLargeChildrenCountPenaltyCoefficient.getValue());
            economicMap.put((Object)PriorityInliningPhase.b.zo, com.oracle.svm.enterprise.hosted.cai.b.HotCompilationMaxPolymorphicDispatches.getValue());
            economicMap.put((Object)PriorityInliningPhase.b.zp, com.oracle.svm.enterprise.hosted.cai.b.HotCompilationMinPolymorphicDispatchProbability.getValue());
            economicMap.put((Object)PriorityInliningPhase.b.zq, com.oracle.svm.enterprise.hosted.cai.b.HotCompilationRelativeBenefitInliningCoefficient.getValue());
            economicMap.put((Object)PriorityInliningPhase.b.yX, com.oracle.svm.enterprise.hosted.cai.b.HotCompilationSmallRootIrPenaltyCoefficient.getValue());
            economicMap.put((Object)PriorityInliningPhase.b.zh, com.oracle.svm.enterprise.hosted.cai.b.HotCompilationTypicalGraphSize.getValue());
            economicMap.put((Object)PriorityInliningPhase.b.zi, com.oracle.svm.enterprise.hosted.cai.b.HotCompilationTypicalGraphSizeInvokeBonus.getValue());
            economicMap.put((Object)EnterpriseHighTier.a.ad, (Object)4);
            economicMap.put((Object)com.oracle.graal.duplication.phases.simulation.e.kM, (Object)2.0);
            economicMap.put((Object)PullThroughPhiPhase.b.jG, (Object)2.0);
            economicMap.put((Object)GraalOptions.LoopMaxUnswitch, (Object)4);
            economicMap.put((Object)DefaultLoopPolicies.Options.LoopUnswitchMaxIncrease, (Object)4000);
            economicMap.put((Object)DefaultLoopPolicies.Options.LoopUnswitchTrivial, (Object)40);
            economicMap.put((Object)DefaultLoopPolicies.Options.LoopUnswitchFrequencyBoost, (Object)40.0);
            economicMap.put((Object)DefaultLoopPolicies.Options.DefaultLoopFrequency, (Object)1000.0);
            economicMap.put((Object)DefaultLoopPolicies.Options.DefaultUnswitchFactor, (Object)0.9);
        }
        return new OptionValues((UnmodifiableEconomicMap)economicMap);
    }

    protected void compileAll() throws InterruptedException {
        this.et();
        this.runOnExecutor(this::er);
        this.ev();
        this.runOnExecutor(this::es);
        super.compileAll();
    }

    private void a(HostedMethod hostedMethod2, CompileQueue.CompileReason compileReason) {
        this.qN.computeIfAbsent(hostedMethod2, hostedMethod -> new HashSet()).add(compileReason);
    }

    protected void ensureCompiled(HostedMethod hostedMethod, CompileQueue.CompileReason compileReason) {
        if (this.qQ) {
            this.b(hostedMethod, compileReason);
        } else {
            super.ensureCompiled(hostedMethod, compileReason);
        }
    }

    private void b(HostedMethod hostedMethod, CompileQueue.CompileReason compileReason) {
        if (compileReason instanceof a) {
            super.ensureCompiled(hostedMethod, compileReason);
        } else {
            this.a(hostedMethod, compileReason);
        }
    }

    protected void ensureCalleesCompiled(HostedMethod hostedMethod, CompileQueue.CompileReason compileReason, CompilationResult compilationResult) {
        if (compileReason instanceof a) {
            this.a(hostedMethod, compileReason, compilationResult);
        } else {
            super.ensureCalleesCompiled(hostedMethod, compileReason, compilationResult);
        }
    }

    private void a(HostedMethod hostedMethod, CompileQueue.CompileReason compileReason, CompilationResult compilationResult) {
        d d2 = d.c(hostedMethod, this.getCustomizedOptions(hostedMethod, this.qO));
        this.a(hostedMethod, compileReason, compilationResult, d2);
        this.ensureCompiledForMethodPointerConstants(hostedMethod, compileReason, compilationResult);
        d2.ew();
    }

    private void a(HostedMethod hostedMethod, CompileQueue.CompileReason compileReason, CompilationResult compilationResult, d d2) {
        a.a(compilationResult, (Call call) -> {
            BytecodePosition bytecodePosition = call.debugInfo != null ? call.debugInfo.getBytecodePosition() : null;
            HostedMethod hostedMethod2 = (HostedMethod)call.target;
            if (call.direct || this.isDynamicallyResolvedCall(compilationResult, (Call)call)) {
                this.a(hostedMethod, compileReason, bytecodePosition, hostedMethod2, d2);
            } else if (hostedMethod2 != null && hostedMethod2.getImplementations() != null) {
                d2.c(bytecodePosition, hostedMethod2);
                for (HostedMethod hostedMethod3 : hostedMethod2.getImplementations()) {
                    this.a(hostedMethod3, (CompileQueue.CompileReason)new CompileQueue.VirtualCallReason(hostedMethod, hostedMethod2, compileReason));
                }
            }
        });
    }

    private static void a(CompilationResult compilationResult, Consumer<Call> consumer) {
        for (Infopoint infopoint : compilationResult.getInfopoints()) {
            if (!(infopoint instanceof Call)) continue;
            Call call = (Call)infopoint;
            consumer.accept(call);
        }
    }

    private void a(HostedMethod hostedMethod, CompileQueue.CompileReason compileReason, BytecodePosition bytecodePosition, HostedMethod hostedMethod2, d d2) {
        e.a a2 = (e.a)this.qL.get(hostedMethod);
        e.a a3 = a2.a(bytecodePosition, (ResolvedJavaMethod)hostedMethod2);
        if (a3 != null && a.a(hostedMethod2, a3) && a3.a(this.qP)) {
            d2.a(bytecodePosition, hostedMethod2);
            a3.a(hostedMethod2, e.c.rw);
            this.qL.put(hostedMethod2, a3);
            this.ensureCompiled(hostedMethod2, new a());
        } else {
            this.a(hostedMethod2, (CompileQueue.CompileReason)new CompileQueue.DirectCallReason(hostedMethod, compileReason));
            d2.b(bytecodePosition, hostedMethod2);
            if (a3 != null) {
                a3.a(hostedMethod2, e.c.rx);
            }
        }
    }

    private static boolean a(HostedMethod hostedMethod, e.a a2) {
        boolean bl2 = hostedMethod.wrapped.equals((Object)a2.getMethod());
        if (!bl2) {
            DebugContext.forCurrentThread().log("[CAICompileQueue] Callee context does not match callee.");
        }
        return bl2;
    }

    private void er() {
        for (Map.Entry<AnalysisMethod, e.b> entry : this.qK.eA().entrySet()) {
            this.b(this.universe.lookup((JavaMethod)entry.getKey()), entry.getValue());
        }
    }

    private void es() {
        this.qN.forEach((hostedMethod, set) -> {
            for (CompileQueue.CompileReason compileReason : set) {
                super.ensureCompiled(hostedMethod, compileReason);
            }
        });
        this.qN.clear();
    }

    private void et() {
        this.qQ = true;
        this.eu();
    }

    private static ListIterator<BasePhase<? super LowTierContext>> a(PhaseSuite<LowTierContext> phaseSuite) {
        ListIterator listIterator = phaseSuite.findPhase(CalculateCallEdgeCountPhase.class);
        return listIterator != null ? listIterator : phaseSuite.findPhase(CalculateCallEdgeInfoPhase.class);
    }

    private void eu() {
        PhaseSuite phaseSuite = this.getRegularSuites().getHighTier();
        ListIterator listIterator = phaseSuite.findPhase(SubstratePriorityInliningPhase.class);
        SubstratePriorityInliningPhase substratePriorityInliningPhase = (SubstratePriorityInliningPhase)((Object)listIterator.previous());
        SubstratePriorityInliningPhase substratePriorityInliningPhase2 = new SubstratePriorityInliningPhase(substratePriorityInliningPhase, new h(this.universe, this.qL::get), this.qM);
        listIterator.remove();
        listIterator.add(substratePriorityInliningPhase2);
        BeforeHotCallerCompilationPhase beforeHotCallerCompilationPhase = new BeforeHotCallerCompilationPhase(this.universe, this.qL::get, this.qM);
        phaseSuite.prependPhase((BasePhase)beforeHotCallerCompilationPhase);
        if (!((Boolean)PLTGOTOptions.EnablePLTGOT.getValue()).booleanValue()) {
            HotMethodDuplicationPhase hotMethodDuplicationPhase = new HotMethodDuplicationPhase(this.qL::get, this.qP);
            PhaseSuite phaseSuite2 = this.getRegularSuites().getLowTier();
            ListIterator<BasePhase<? super LowTierContext>> listIterator2 = a.a((PhaseSuite<LowTierContext>)phaseSuite2);
            if (listIterator2 == null) {
                phaseSuite2.appendPhase(hotMethodDuplicationPhase);
            } else {
                listIterator2.previous();
                listIterator2.add(hotMethodDuplicationPhase);
            }
        } else {
            HotMethodDuplicationPhase hotMethodDuplicationPhase = new HotMethodDuplicationPhase(this.qL::get, this.qP);
            ListIterator listIterator3 = phaseSuite.findPhase(HighTierLoweringPhase.class);
            phaseSuite.insertAtIndex(listIterator3.previousIndex(), hotMethodDuplicationPhase);
        }
    }

    private static OptionValues b(OptionValues optionValues) {
        EconomicMap economicMap = EconomicMap.create((UnmodifiableEconomicMap)optionValues.getMap());
        bc.a(economicMap, true);
        return new OptionValues((UnmodifiableEconomicMap)economicMap);
    }

    private void ev() {
        this.qQ = false;
        this.createSuites();
        OptionValues optionValues = a.b(HostedOptionValues.singleton());
        this.qR = NativeImageGenerator.createSuites((FeatureHandler)this.featureHandler, (RuntimeConfiguration)this.runtimeConfig, (boolean)true, (OptionValues)optionValues);
        this.modifyRegularSuites(this.qR);
        PhaseSuite phaseSuite = this.qR.getHighTier();
        phaseSuite.removeSubTypePhases(SubstratePriorityInliningPhase.class);
    }

    protected Suites createSuitesForRegularCompile(StructuredGraph structuredGraph, Suites suites) {
        if (this.b((HostedMethod)structuredGraph.method(), structuredGraph.getOptions())) {
            return this.qR;
        }
        return super.createSuitesForRegularCompile(structuredGraph, suites);
    }

    private boolean a(HostedMethod hostedMethod, OptionValues optionValues) {
        if (hostedMethod == null) {
            return false;
        }
        if (this.qK == null || this.qK.g(hostedMethod)) {
            return false;
        }
        long l2 = this.e(hostedMethod);
        return l2 <= (long)((Integer)com.oracle.svm.enterprise.hosted.cai.b.CAIColdCodeMaxInvocations.getValue(optionValues)).intValue();
    }

    private boolean b(HostedMethod hostedMethod, OptionValues optionValues) {
        if (!PGOFeature.isUserCollectedPGOEnabled()) {
            return false;
        }
        if (((Boolean)com.oracle.svm.enterprise.hosted.cai.b.CAIAggressiveColdCodeOptimizations.getValue(optionValues)).booleanValue()) {
            return false;
        }
        if (this.qR == null) {
            return false;
        }
        return this.a(hostedMethod, optionValues);
    }

    private Long e(HostedMethod hostedMethod) {
        return this.qM.getCallCountProfile(hostedMethod).map(profiledValue -> profiledValue.source().isProfiled() ? (Long)profiledValue.value() : 0L).orElse(0L);
    }

    private void b(HostedMethod hostedMethod, e.a a2) {
        a2.a(hostedMethod, e.c.rw);
        e.a a3 = this.qL.putIfAbsent(hostedMethod, a2);
        assert (a3 == null);
        this.ensureCompiled(hostedMethod, new a());
    }

    protected void customizeGraph(StructuredGraph structuredGraph, CompileQueue.CompileReason compileReason) {
        structuredGraph.setGlobalProfileProvider((StructuredGraph.GlobalProfileProvider)new b(structuredGraph, compileReason));
    }

    public static class a
    extends CompileQueue.CompileReason {
        public a() {
            super(null);
        }

        public String toString() {
            return "hot caller";
        }
    }

    final class b
    implements StructuredGraph.GlobalProfileProvider {
        private final StructuredGraph qS;
        private final CompileQueue.CompileReason qT;

        b(StructuredGraph structuredGraph, CompileQueue.CompileReason compileReason) {
            this.qS = structuredGraph;
            this.qT = compileReason;
        }

        public double getGlobalSelfTimePercent() {
            ResolvedJavaMethod resolvedJavaMethod = this.qS.method();
            assert (resolvedJavaMethod instanceof HostedMethod);
            e.a a2 = (e.a)a.this.qL.get(resolvedJavaMethod);
            if (a2 == null) {
                return 0.0;
            }
            long l2 = a2.eD();
            for (Invoke invoke : this.qS.getInvokes()) {
                assert (invoke.getTargetMethod() instanceof HostedMethod);
                HostedMethod hostedMethod = (HostedMethod)invoke.getTargetMethod();
                e.a a3 = a2.a((BytecodePosition)invoke.asNode().getNodeSourcePosition(), (ResolvedJavaMethod)hostedMethod);
                HostedMethod hostedMethod2 = (HostedMethod)resolvedJavaMethod;
                if (a3 == null || Objects.equals(hostedMethod.wrapped, hostedMethod2.wrapped)) continue;
                l2 -= a3.eD();
            }
            return Math.max((double)l2, 0.0) / (double)a.this.qK.ey();
        }

        public boolean hotCaller() {
            return this.qT instanceof a;
        }
    }
}

